/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.dataweave;

import org.mule.weave.v2.module.DataFormat;
import static org.mule.weave.v2.module.DataFormatManager.byContentType;
import org.mule.weave.v2.module.option.ModuleOption;
import org.mule.tooling.client.api.dataweave.DataWeaveModuleOption;
import scala.Option;
import scala.collection.JavaConverters$;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ModulesAnalyzer {

  public List<DataWeaveModuleOption> getOptions(String contentType,
                                                Function<DataFormat, scala.collection.immutable.Map<String, ModuleOption>> getter) {
    Option<DataFormat> moduleOption = byContentType(contentType);
    if (moduleOption.nonEmpty()) {
      List<DataWeaveModuleOption> response = new ArrayList<>();
      Map<String, ModuleOption> convert = convert(getter.apply(moduleOption.get()));
      convert.values().forEach(option -> response.add(toRestModel(option)));
      return response;
    }
    throw new IllegalArgumentException("Module for " + contentType + " not found");
  }

  private <K, V> Map<K, V> convert(scala.collection.immutable.Map<K, V> m) {
    return JavaConverters$.MODULE$.mapAsJavaMapConverter(m).asJava();
  }

  private DataWeaveModuleOption toRestModel(ModuleOption option) {
    DataWeaveModuleOption model = new DataWeaveModuleOption();
    model.setName(option.name());
    model.setType(option.dataType().toString());
    model.setDefaultValue(toString(option));
    model.setDescription(option.description());
    model.setPossibleValues(option.possibleValues().mkString(","));
    return model;
  }

  private String toString(ModuleOption option) {
    return option.defaultValue().toString();
  }
}
