/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.CompositeModuleDiscoverer;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClientBuilder;
import org.mule.tooling.client.internal.DomainCache;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.log4j.ToolingLog4jContextFactory;
import org.mule.tooling.client.internal.serialization.KryoServerSerializer;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.XStreamServerSerializer;
import org.mule.tooling.client.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolingRuntimeClientFactory
implements ToolingRuntimeClientBuilderFactory,
Command,
Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISABLE = "tooling.client.ExtensionModelServiceCache.disable";
    private String muleVersion;
    private final ArtifactClassLoader containerClassLoaderFactory;
    private final ModuleRepository moduleRepository;
    private Optional<ExtensionModelServiceCache> extensionModelServiceCache = Optional.empty();
    private ApplicationCache applicationCache;
    private DomainCache domainCache;
    private DslSyntaxServiceCache dslSyntaxServiceCache;
    private LazyValue<Serializer> serializer = new LazyValue(() -> new XStreamServerSerializer());

    public DefaultToolingRuntimeClientFactory(String muleVersion) {
        this.muleVersion = muleVersion;
        if (!Boolean.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISABLE, "false")).booleanValue()) {
            this.extensionModelServiceCache = Optional.of(new ExtensionModelServiceCache(muleVersion));
        }
        this.moduleRepository = DefaultToolingRuntimeClientFactory.createModuleRepository();
        this.containerClassLoaderFactory = DefaultToolingRuntimeClientFactory.createContainerClassLoader(this.moduleRepository);
        this.applicationCache = new ApplicationCache();
        this.domainCache = new DomainCache();
        this.dslSyntaxServiceCache = new DslSyntaxServiceCache();
    }

    public void setSerialization(String name) {
        Preconditions.checkState((boolean)this.getSupportedSerialization().contains(name), (String)String.format("Not supported serialization '%s', the ones supported by this implementation are: %s", name, this.getSupportedSerialization()));
        if (XStreamServerSerializer.NAME.equals(name)) {
            this.serializer = new LazyValue(() -> new XStreamServerSerializer());
        } else if (KryoServerSerializer.NAME.equals(name)) {
            this.serializer = new LazyValue(() -> new KryoServerSerializer());
        }
    }

    private List<String> getSupportedSerialization() {
        return ImmutableList.builder().add((Object[])new String[]{XStreamServerSerializer.NAME, KryoServerSerializer.NAME}).build();
    }

    public static ArtifactClassLoader createContainerClassLoader(ModuleRepository moduleRepository) {
        ArtifactClassLoader containerClassLoaderFactory = new ContainerClassLoaderFactory(moduleRepository).createContainerClassLoader(DefaultToolingRuntimeClientFactory.class.getClassLoader());
        return containerClassLoaderFactory;
    }

    public static ModuleRepository createModuleRepository() {
        ModuleDiscoverer jreModuleDiscoverer = new ModuleDiscoverer(){
            List<MuleModule> muleModules;

            public List<MuleModule> discover() {
                if (this.muleModules == null) {
                    this.muleModules = new JreModuleDiscoverer().discover();
                }
                return this.muleModules;
            }
        };
        CompositeModuleDiscoverer moduleDiscoverer = new CompositeModuleDiscoverer(new ModuleDiscoverer[]{jreModuleDiscoverer, new DuplicateClasspathModuleDiscoverer(DefaultToolingRuntimeClientFactory.class.getClassLoader())});
        return () -> DefaultToolingRuntimeClientFactory.lambda$createModuleRepository$3((ModuleDiscoverer)moduleDiscoverer);
    }

    public ToolingRuntimeClient.Builder create() {
        return new DefaultToolingRuntimeClientBuilder(this.muleVersion, (Serializer)this.serializer.get(), this.moduleRepository, this.containerClassLoaderFactory, this.extensionModelServiceCache, this.applicationCache, this.domainCache, this.dslSyntaxServiceCache);
    }

    public void dispose() {
        this.extensionModelServiceCache.ifPresent(service -> this.dispose((Disposable)service));
        this.dispose(this.domainCache);
        this.dispose(this.applicationCache);
        this.dispose(this.dslSyntaxServiceCache);
        if (LogManager.getFactory() instanceof ToolingLog4jContextFactory) {
            ((ToolingLog4jContextFactory)LogManager.getFactory()).dispose();
        }
    }

    private void dispose(Disposable disposable) {
        try {
            disposable.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "dispose": {
                this.dispose();
                return null;
            }
            case "create": {
                return this.create();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid arguments passed for calling method '%s' on '%s'", methodName, this.getClass()));
    }

    private static List<ExportedService> getExportedServices(Properties moduleProperties, String exportedServicesProperty) {
        String privilegedExportedPackagesProperty = (String)moduleProperties.get(exportedServicesProperty);
        List<ExportedService> exportedServices = !StringUtils.isEmpty((CharSequence)privilegedExportedPackagesProperty) ? DefaultToolingRuntimeClientFactory.getServicesFromProperty(privilegedExportedPackagesProperty) : new ArrayList<ExportedService>();
        return exportedServices;
    }

    private static List<ExportedService> getServicesFromProperty(String privilegedExportedPackagesProperty) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (String exportedServiceDefinition : privilegedExportedPackagesProperty.split(",")) {
            URL resource;
            String[] split = exportedServiceDefinition.split(":");
            String serviceInterface = split[0];
            String serviceImplementation = split[1];
            BytesURLStreamHandler bytesURLStreamHandler = new BytesURLStreamHandler(serviceImplementation.getBytes());
            try {
                resource = new URL("custom", "none", 9999, "none", bytesURLStreamHandler);
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            exportedServices.add(new ExportedService(serviceInterface, resource));
        }
        return exportedServices;
    }

    private static /* synthetic */ List lambda$createModuleRepository$3(ModuleDiscoverer moduleDiscoverer) {
        return moduleDiscoverer.discover();
    }

    public static class BytesURLConnection
    extends URLConnection {
        protected byte[] content;

        public BytesURLConnection(URL url, byte[] content) {
            super(url);
            this.content = content;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.content);
        }
    }

    public static class BytesURLStreamHandler
    extends URLStreamHandler {
        byte[] content;

        public BytesURLStreamHandler(byte[] content) {
            this.content = content;
        }

        @Override
        public URLConnection openConnection(URL url) {
            return new BytesURLConnection(url, this.content);
        }
    }

    private static class DuplicateClasspathModuleDiscoverer
    implements ModuleDiscoverer {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final ClassLoader classLoader;

        public DuplicateClasspathModuleDiscoverer(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public List<MuleModule> discover() {
            LinkedList<MuleModule> modules = new LinkedList<MuleModule>();
            HashSet<String> moduleNames = new HashSet<String>();
            try {
                for (Properties moduleProperties : PropertiesUtils.discoverProperties((ClassLoader)this.classLoader, (String)"META-INF/mule-module.properties")) {
                    MuleModule module = this.createModule(moduleProperties);
                    if (moduleNames.contains(module.getName())) {
                        this.logger.warn(String.format("Module '%s' was already defined", module.getName()));
                    }
                    moduleNames.add(module.getName());
                    modules.add(module);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot discover mule modules", e);
            }
            return modules;
        }

        private MuleModule createModule(Properties moduleProperties) {
            String moduleName = (String)moduleProperties.get("module.name");
            Set<String> modulePackages = this.getExportedPackageByProperty(moduleProperties, "artifact.export.classPackages");
            Set<String> modulePaths = this.getExportedResourcePaths(moduleProperties);
            Set<String> modulePrivilegedPackages = this.getExportedPackageByProperty(moduleProperties, "artifact.privileged.classPackages");
            Set<String> privilegedArtifacts = this.getPrivilegedArtifactIds(moduleProperties);
            List exportedServices = DefaultToolingRuntimeClientFactory.getExportedServices(moduleProperties, "artifact.export.services");
            return new MuleModule(moduleName, modulePackages, modulePaths, modulePrivilegedPackages, privilegedArtifacts, exportedServices);
        }

        private Set<String> getPrivilegedArtifactIds(Properties moduleProperties) {
            String privilegedArtifactsProperty = (String)moduleProperties.get("artifact.privileged.artifactIds");
            HashSet<String> artifactsIds = new HashSet<String>();
            if (!StringUtils.isEmpty((CharSequence)privilegedArtifactsProperty)) {
                for (String artifactName : privilegedArtifactsProperty.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)artifactName.trim())) continue;
                    artifactsIds.add(artifactName);
                }
            }
            HashSet<String> privilegedArtifacts = artifactsIds;
            return privilegedArtifacts;
        }

        private Set<String> getExportedPackageByProperty(Properties moduleProperties, String privilegedExportedClassPackagesProperty) {
            String privilegedExportedPackagesProperty = (String)moduleProperties.get(privilegedExportedClassPackagesProperty);
            Set<String> modulePrivilegedPackages = !StringUtils.isEmpty((CharSequence)privilegedExportedPackagesProperty) ? this.getPackagesFromProperty(privilegedExportedPackagesProperty) : new HashSet<String>();
            return modulePrivilegedPackages;
        }

        private Set<String> getExportedResourcePaths(Properties moduleProperties) {
            HashSet<String> paths = new HashSet<String>();
            String exportedResourcesProperty = (String)moduleProperties.get("artifact.export.resources");
            if (!StringUtils.isEmpty((CharSequence)exportedResourcesProperty)) {
                for (String path : exportedResourcesProperty.split(",")) {
                    if (StringUtils.isEmpty((CharSequence)path.trim())) continue;
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    paths.add(path);
                }
            }
            return paths;
        }

        private Set<String> getPackagesFromProperty(String privilegedExportedPackagesProperty) {
            HashSet<String> packages = new HashSet<String>();
            for (String packageName : privilegedExportedPackagesProperty.split(",")) {
                if (StringUtils.isEmpty((CharSequence)(packageName = packageName.trim()))) continue;
                packages.add(packageName);
            }
            return packages;
        }
    }
}

