/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.persistence.TypeAnnotationEntryKey;
import org.mule.tooling.client.internal.serialization.DefaultArrayTypeSerializer;
import org.mule.tooling.client.internal.serialization.KryoFactory;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.TypeAnnotationsTransformers;
import org.mule.tooling.client.internal.serialization.TypeIdAnnotationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoServerSerializer
implements Serializer {
    public static String NAME = "kryo";
    private static Logger LOGGER = LoggerFactory.getLogger(KryoServerSerializer.class);

    private static Kryo createKryo() {
        Kryo kryo = KryoFactory.createKryo();
        kryo.addDefaultSerializer(DefaultArrayType.class, (com.esotericsoftware.kryo.Serializer)new DefaultArrayTypeSerializer());
        kryo.register(LinkedHashMap.class, (com.esotericsoftware.kryo.Serializer)new TypeAnnotationsMapSerializer());
        return kryo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String serialize(Object object) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                KryoServerSerializer.createKryo().writeClassAndObject(output, object);
            }
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new ToolingException("Error while creating object from serialization", (Throwable)e);
        }
    }

    public <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = KryoServerSerializer.createKryo().readClassAndObject(input);
            return (T)object;
        }
    }

    private static class TypeAnnotationsMapSerializer
    extends MapSerializer {
        private TypeAnnotationsMapSerializer() {
        }

        public void write(Kryo kryo, Output output, Map map) {
            if (map.isEmpty()) {
                super.write(kryo, output, (Map)map);
                return;
            }
            Map.Entry entry = map.entrySet().iterator().next();
            if (entry.getKey() instanceof Class && TypeAnnotation.class.isAssignableFrom((Class)entry.getKey())) {
                LinkedHashMap<TypeAnnotationEntryKey, Object> typeAnnotationMap = map;
                LinkedHashMap<TypeAnnotationEntryKey, Object> toTypeAnnotationTransformedMap = new LinkedHashMap<TypeAnnotationEntryKey, Object>();
                for (Map.Entry e : typeAnnotationMap.entrySet()) {
                    if (!((TypeAnnotation)e.getValue()).isPublic()) continue;
                    if (TypeAnnotationsTransformers.typeAnnotationTransformers.containsKey(e.getKey())) {
                        TypeAnnotation transformed = (TypeAnnotation)TypeAnnotationsTransformers.typeAnnotationTransformers.get(e.getKey()).transform(e.getValue());
                        toTypeAnnotationTransformedMap.put(new TypeAnnotationEntryKey(transformed.getName()), transformed);
                        continue;
                    }
                    if (((Class)e.getKey()).getPackage().getName().startsWith("org.mule.metadata") || ((Class)e.getKey()).getPackage().getName().startsWith("org.mule.tooling.client.api")) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("No need for transformation of typeAnnotation {}", e.getKey());
                        }
                        toTypeAnnotationTransformedMap.put(new TypeAnnotationEntryKey(((TypeAnnotation)e.getValue()).getName()), e.getValue());
                        continue;
                    }
                    LOGGER.warn(String.format("Cannot find a transformer for typeAnnotation %s", e.getKey()));
                    throw new IllegalStateException(String.format("Cannot find a transformer for typeAnnotation %s", e.getKey()));
                }
                map = toTypeAnnotationTransformedMap;
            }
            super.write(kryo, output, (Map)map);
        }

        public Map read(Kryo kryo, Input input, Class<Map> type) {
            Map map = this.create(kryo, input, type);
            int length = input.readInt(true);
            kryo.reference((Object)map);
            for (int i = 0; i < length; ++i) {
                Object key = kryo.readClassAndObject(input);
                if (key instanceof TypeAnnotationEntryKey) {
                    String typeId = ((TypeAnnotationEntryKey)key).getTypeId();
                    if (TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.containsKey(typeId)) {
                        key = TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.get(typeId);
                    } else {
                        LOGGER.debug("Unknown typeId:'{}' when unmarshalling TypeAnnotation", (Object)typeId);
                        key = null;
                    }
                }
                Object value = null;
                if (key != null) {
                    value = kryo.readClassAndObject(input);
                }
                if (key == null || value == null) continue;
                if (TypeAnnotationsTransformers.toolingTypeAnnotationTransformers.containsKey(key)) {
                    value = TypeAnnotationsTransformers.toolingTypeAnnotationTransformers.get(key).transform((Object)((TypeAnnotation)value));
                    key = value.getClass();
                }
                map.put(key, value);
            }
            return map;
        }
    }
}

