/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.tooling.client.internal.persistence.TypeAnnotationEntryKey;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.TypeAnnotationsTransformers;
import org.mule.tooling.client.internal.serialization.TypeIdAnnotationMapper;
import org.mule.tooling.client.internal.serialization.XStreamFactory;
import org.mule.tooling.client.internal.serialization.XmlArtifactDeserializationRequestConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamServerSerializer
implements Serializer {
    public static String NAME = "xStream";
    private static Logger LOGGER = LoggerFactory.getLogger(XStreamServerSerializer.class);

    private static XStream createXStream() {
        XStream xStream = XStreamFactory.createXStream();
        xStream.registerConverter((Converter)new TypeAnnotationsMapConverter(xStream.getMapper()));
        xStream.registerConverter((Converter)new XmlArtifactDeserializationRequestConverter(xStream.getMapper()));
        xStream.ignoreUnknownElements();
        return xStream;
    }

    public String serialize(Object object) {
        return XStreamServerSerializer.createXStream().toXML(object);
    }

    public <T> T deserialize(String content) {
        return (T)XStreamServerSerializer.createXStream().fromXML(content);
    }

    private static class TypeAnnotationsMapConverter
    extends MapConverter {
        public TypeAnnotationsMapConverter(Mapper mapper) {
            super(mapper);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Map map = source;
            if (map.isEmpty()) {
                super.marshal((Object)source, writer, context);
                return;
            }
            Map.Entry entry = map.entrySet().iterator().next();
            if (entry.getKey() instanceof Class && TypeAnnotation.class.isAssignableFrom((Class)entry.getKey())) {
                Map typeAnnotationMap = map;
                LinkedHashMap<TypeAnnotationEntryKey, Object> toTypeAnnotationTransformedMap = new LinkedHashMap<TypeAnnotationEntryKey, Object>();
                for (Map.Entry e : typeAnnotationMap.entrySet()) {
                    if (!((TypeAnnotation)e.getValue()).isPublic()) continue;
                    if (TypeAnnotationsTransformers.typeAnnotationTransformers.containsKey(e.getKey())) {
                        TypeAnnotation transformed = (TypeAnnotation)TypeAnnotationsTransformers.typeAnnotationTransformers.get(e.getKey()).transform(e.getValue());
                        toTypeAnnotationTransformedMap.put(new TypeAnnotationEntryKey(transformed.getName()), transformed);
                        continue;
                    }
                    if (((Class)e.getKey()).getPackage().getName().startsWith("org.mule.metadata") || ((Class)e.getKey()).getPackage().getName().startsWith("org.mule.tooling.client.api")) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("No need for transformation of typeAnnotation {}", e.getKey());
                        }
                        toTypeAnnotationTransformedMap.put(new TypeAnnotationEntryKey(((TypeAnnotation)e.getValue()).getName()), e.getValue());
                        continue;
                    }
                    LOGGER.warn(String.format("Cannot find a transformer for typeAnnotation %s", e.getKey()));
                    throw new IllegalStateException(String.format("Cannot find a transformer for typeAnnotation %s", e.getKey()));
                }
                source = toTypeAnnotationTransformedMap;
            }
            super.marshal((Object)source, writer, context);
        }

        protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
            reader.moveDown();
            Class<?> key = this.readItem(reader, context, map);
            reader.moveUp();
            Object value = null;
            reader.moveDown();
            if (key instanceof TypeAnnotationEntryKey) {
                String typeId = ((TypeAnnotationEntryKey)key).getTypeId();
                if (TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.containsKey(typeId)) {
                    key = TypeIdAnnotationMapper.TYPE_ANNOTATIONS_MAPPING.get(typeId);
                } else {
                    LOGGER.debug("Unknown typeId:'{}' when unmarshalling TypeAnnotation", (Object)typeId);
                    key = null;
                }
            }
            if (key != null) {
                value = this.readItem(reader, context, map);
            }
            reader.moveUp();
            if (key != null && value != null) {
                if (TypeAnnotationsTransformers.toolingTypeAnnotationTransformers.containsKey(key)) {
                    value = TypeAnnotationsTransformers.toolingTypeAnnotationTransformers.get(key).transform((Object)((TypeAnnotation)value));
                    key = value.getClass();
                }
                target.put(key, value);
            }
        }
    }
}

