/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.application.AbstractArtifactDeployer;
import org.mule.tooling.client.internal.application.ArtifactResources;

public class FileSystemArtifactDeployer
extends AbstractArtifactDeployer {
    private Function<AbstractArtifactDeployer.DeploymentContext, String> deployFunction;
    private Consumer<AbstractArtifactDeployer.DeploymentContext> disposeFunction;

    public FileSystemArtifactDeployer(ArtifactResources artifactResources, Supplier<RuntimeToolingService> runtimeToolingService) {
        super(artifactResources, runtimeToolingService);
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.DOMAIN)) {
            this.deployFunction = deploymentContext -> {
                if (deploymentContext.getLocalLocation() != null) {
                    return deploymentContext.getRuntimeToolingService().deployDomain(deploymentContext.getLocalLocation());
                }
                return deploymentContext.getRuntimeToolingService().deployDomain(deploymentContext.getContent());
            };
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeDomain(deploymentContext.getArtifactId());
        } else {
            this.deployFunction = deploymentContext -> {
                if (deploymentContext.getDomainId() != null) {
                    if (deploymentContext.getLocalLocation() != null) {
                        return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getLocalLocation(), deploymentContext.getDomainId());
                    }
                    return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getContent(), deploymentContext.getDomainId());
                }
                if (deploymentContext.getLocalLocation() != null) {
                    return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getLocalLocation());
                }
                return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getContent());
            };
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeApplication(deploymentContext.getArtifactId());
        }
    }

    @Override
    protected String doInternalDeploy(ArtifactResources artifactResources, RuntimeToolingService runtimeToolingService, String domainId) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Deploying application from: {}", (Object)artifactResources);
        }
        return this.deployFunction.apply((AbstractArtifactDeployer)this.new AbstractArtifactDeployer.DeploymentContext(artifactResources.getRootArtifactFile(), domainId, runtimeToolingService));
    }

    @Override
    protected void doInternalDispose(String id, RuntimeToolingService runtimeToolingService) {
        this.disposeFunction.accept(new AbstractArtifactDeployer.DeploymentContext(id, runtimeToolingService));
    }
}

