/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.el.mvel.function.PropertyAccessFunction;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunner;
import org.mule.tooling.client.internal.dataweave.MockCausedByFunction;
import org.mule.tooling.client.internal.dataweave.MockLookupFunction;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.weave.v2.el.WeaveExpressionLanguage;

public class LocalRunner
implements DataWeaveRunner {
    private static final String APPLICATION_JAVA = "application/java";
    private static final String DEFAULT_ATTRIBUTES_MEDIA_TYPE = "application/java";
    private static final DataType VARS_DATA_TYPE = DataType.builder().mapType(Map.class).keyType(String.class).valueType(TypedValue.class).build();
    public static final TypedValue EMPTY_VARS = new TypedValue(Collections.emptyMap(), VARS_DATA_TYPE);
    private static final Supplier<TypedValue> EMPTY_VARS_SUPPLIER = () -> EMPTY_VARS;
    public static final TypedValue NULL_TYPED_VALUE = new TypedValue(null, DataType.OBJECT);
    private static final Supplier<TypedValue> NULL_TYPED_VALUE_SUPPLIER = () -> NULL_TYPED_VALUE;
    private LazyValue<ClassLoader> executionClassLoader;
    private LazyValue<ConfigurationProperties> configurationProperties;

    public LocalRunner(LazyValue<ClassLoader> executionClassLoader, LazyValue<ConfigurationProperties> configurationProperties) {
        Objects.requireNonNull(executionClassLoader, "executionClassLoader cannot be null");
        Objects.requireNonNull(configurationProperties, "configurationProperties cannot be null");
        this.executionClassLoader = executionClassLoader;
        this.configurationProperties = configurationProperties;
    }

    @Override
    public DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters) {
        return (DataWeavePreviewResponse)ClassUtils.withContextClassLoader((ClassLoader)((ClassLoader)this.executionClassLoader.get()), () -> {
            try {
                WeaveExpressionLanguage executor = new WeaveExpressionLanguage();
                TypedValue response = executor.evaluate(this.getScript(parameters), this.buildContextFromParameters(parameters), parameters.getRequestTimeout());
                return DataWeavePreviewResponse.builder().result(this.getResult(response)).mediaType(this.getMediaType(response)).valid(Boolean.valueOf(true)).build();
            }
            catch (Exception e) {
                return DataWeavePreviewResponse.builder().errorMessage(ExceptionHelper.getRootException((Throwable)e).getMessage()).build();
            }
        });
    }

    private String getMediaType(TypedValue evaluate) {
        DataType dataType = evaluate.getDataType();
        MediaType mediaType = dataType.getMediaType();
        return mediaType.withoutParameters().toString();
    }

    private String getResult(TypedValue result) {
        Object value = result.getValue();
        if (value instanceof CursorStreamProvider) {
            return this.manageCursorStream((TypedValue<CursorStreamProvider>)result);
        }
        return this.serializeObject(value);
    }

    /*
     * Exception decompiling
     */
    protected String manageCursorStream(TypedValue<CursorStreamProvider> result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String serializeObject(Object value) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(value);
    }

    private BindingContext buildContextFromParameters(DataWeavePreviewRequest parameters) throws IOException {
        BindingContext.Builder bindingBuilder = BindingContext.builder();
        EventModel event = this.getEvent(parameters);
        if (event != null) {
            this.manageVariables(bindingBuilder, event);
            this.manageMessage(bindingBuilder, event);
        } else {
            bindingBuilder.addBinding("attributes", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("payload", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("dataType", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("vars", EMPTY_VARS_SUPPLIER);
        }
        this.appendGlobalBindings(bindingBuilder);
        this.appendFunctions(bindingBuilder);
        return bindingBuilder.build();
    }

    private void appendGlobalBindings(BindingContext.Builder bindingBuilder) {
        bindingBuilder.addBinding("authentication", new TypedValue(null, DataType.fromType(Authentication.class)));
        bindingBuilder.addBinding("correlationId", new TypedValue(null, DataType.STRING));
        bindingBuilder.addBinding("flow", new TypedValue(null, DataType.fromType(NamedObject.class)));
        bindingBuilder.addBinding("itemSequenceInfo", new TypedValue(null, DataType.fromType(ItemSequenceInfo.class)));
        bindingBuilder.addBinding("error", new TypedValue(null, DataType.fromType(Error.class)));
    }

    private void appendFunctions(BindingContext.Builder builder) {
        PropertyAccessFunction propertyFunction = new PropertyAccessFunction((ConfigurationProperties)this.configurationProperties.get());
        builder.addBinding("p", new TypedValue((Object)propertyFunction, DataType.fromFunction((ExpressionFunction)propertyFunction)));
        MockLookupFunction lookupFunction = new MockLookupFunction();
        builder.addBinding("lookup", new TypedValue((Object)lookupFunction, DataType.fromFunction((ExpressionFunction)lookupFunction)));
        MockCausedByFunction causedByFunction = new MockCausedByFunction();
        builder.addBinding("causedBy", new TypedValue((Object)causedByFunction, DataType.fromFunction((ExpressionFunction)causedByFunction)));
    }

    private void manageMessage(BindingContext.Builder bindingBuilder, EventModel event) throws IOException {
        MessageModel message = event.getMessage();
        if (message != null) {
            if (message.getAttributes() != null) {
                bindingBuilder.addBinding("attributes", this.asTypedValue(message.getAttributes()));
            } else {
                bindingBuilder.addBinding("attributes", NULL_TYPED_VALUE_SUPPLIER);
            }
            if (message.getPayload() != null) {
                bindingBuilder.addBinding("payload", this.asTypedValue(message.getPayload()));
                bindingBuilder.addBinding("dataType", new TypedValue((Object)DataType.builder().type(String.class).mediaType(message.getPayload().getDataType().getMediaType()).build(), DataType.fromType(DataType.class)));
            } else {
                bindingBuilder.addBinding("payload", NULL_TYPED_VALUE_SUPPLIER);
                bindingBuilder.addBinding("dataType", NULL_TYPED_VALUE_SUPPLIER);
            }
        } else {
            bindingBuilder.addBinding("attributes", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("payload", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("dataType", NULL_TYPED_VALUE_SUPPLIER);
        }
    }

    private void manageVariables(BindingContext.Builder bindingBuilder, EventModel event) throws IOException {
        if (event.getVariables() != null && !event.getVariables().isEmpty()) {
            HashMap variables = new HashMap();
            for (Map.Entry pair : event.getVariables().entrySet()) {
                variables.put(pair.getKey(), this.asTypedValue((TypedValueModel)pair.getValue()));
            }
            DataType variablesDataType = DataType.builder().type(Map.class).mediaType("application/java").build();
            bindingBuilder.addBinding("vars", new TypedValue(variables, variablesDataType));
        } else {
            bindingBuilder.addBinding("vars", EMPTY_VARS);
        }
    }

    protected TypedValue<?> asTypedValue(TypedValueModel restTypedValue) throws IOException {
        String mediaType = restTypedValue.getDataType().getMediaType();
        if ("application/java".equals(mediaType)) {
            throw new IllegalArgumentException("Java input not supported, serialize to DW script");
        }
        DataType dataType = DataType.builder().type(String.class).mediaType(mediaType).build();
        return new TypedValue((Object)new String(restTypedValue.getContent(), "UTF-8"), dataType);
    }

    private EventModel getEvent(DataWeavePreviewRequest parameters) {
        return parameters.getEvent();
    }

    private String getScript(DataWeavePreviewRequest parameters) {
        return parameters.getScript();
    }
}

