/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.internal.ArtifactConfigResolverContext;
import org.mule.runtime.config.internal.DefaultArtifactConfigResolver;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.config.RuntimeComponentBuildingDefinitionsUtil;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.ApplicationModelFactory;

public class DefaultApplicationModelFactory
implements ApplicationModelFactory {
    @Override
    public Optional<ApplicationModel> createApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor, Set<ExtensionModel> extensionModels, ClassLoader applicationClassLoader, ConfigurationProperties parentConfigurationProperties) {
        try {
            return Optional.of(this.loadApplicationModel(deployableArtifactDescriptor, extensionModels, applicationClassLoader, parentConfigurationProperties));
        }
        catch (Exception e) {
            throw new ToolingException("Error while creating application model", (Throwable)e);
        }
    }

    private ApplicationModel loadApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor, Set<ExtensionModel> extensionModels, ClassLoader applicationClassLoader, ConfigurationProperties parentConfigurationProperties) throws Exception {
        ClassLoader parent = applicationClassLoader.getParent();
        if (!(parent instanceof RegionClassLoader)) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)String.format("The parent of the current artifact classloader must be of type '%s' but found '%s'", RegionClassLoader.class.getName(), parent.getClass().getName())));
        }
        ArtifactConfig artifactConfig = new DefaultArtifactConfigResolver().resolveArtifactConfig((ArtifactConfigResolverContext)new ToolingArtifactConfigResolverContext(deployableArtifactDescriptor, extensionModels, (RegionClassLoader)parent, applicationClassLoader));
        Optional<Object> parentConfigurationPropertiesOptional = parentConfigurationProperties != null ? Optional.of(parentConfigurationProperties) : Optional.of(new EmptyConfigurationProperties());
        return (ApplicationModel)ClassUtils.withContextClassLoader((ClassLoader)applicationClassLoader, () -> {
            ApplicationModel applicationModel = new ApplicationModel(artifactConfig, null, extensionModels, Collections.emptyMap(), parentConfigurationPropertiesOptional, Optional.of(DefaultApplicationModelFactory.createComponentBuildingDefinitionRegistry()), false, (ResourceProvider)new ClassLoaderResourceProvider(applicationClassLoader));
            return applicationModel;
        });
    }

    private static ComponentBuildingDefinitionRegistry createComponentBuildingDefinitionRegistry() {
        ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
        RuntimeComponentBuildingDefinitionsUtil.getRuntimeComponentBuildingDefinitionProvider().getComponentBuildingDefinitions().forEach(arg_0 -> ((ComponentBuildingDefinitionRegistry)componentBuildingDefinitionRegistry).register(arg_0));
        return componentBuildingDefinitionRegistry;
    }

    private class ToolingArtifactConfigResolverContext
    implements ArtifactConfigResolverContext {
        private Set<ExtensionModel> extensionModels;
        private XmlApplicationParser xmlApplicationParser;
        private XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader;
        private DeployableArtifactDescriptor artifactDescriptor;
        private ClassLoader regionClassLoader;
        private ConfigResource[] configResources;

        public ToolingArtifactConfigResolverContext(DeployableArtifactDescriptor artifactDescriptor, Set<ExtensionModel> extensionModels, RegionClassLoader regionClassLoader, ClassLoader artifactClassLoader) {
            this.artifactDescriptor = artifactDescriptor;
            this.extensionModels = extensionModels;
            this.regionClassLoader = regionClassLoader;
            this.xmlApplicationParser = XmlApplicationParser.createFromExtensionModels(extensionModels);
            this.xmlConfigurationDocumentLoader = XmlConfigurationDocumentLoader.noValidationDocumentLoader();
            this.configResources = (ConfigResource[])artifactDescriptor.getConfigResources().stream().map(configFile -> {
                URL url = artifactClassLoader.getResource((String)configFile);
                if (url == null) {
                    throw new ToolingException(String.format("Configuration file '%s' cannot be found", configFile));
                }
                try {
                    return new ConfigResource(configFile, url.openStream());
                }
                catch (IOException e) {
                    throw new ToolingException(String.format("Error while reading configuration file '%s'", configFile), (Throwable)e);
                }
            }).toArray(ConfigResource[]::new);
        }

        public Map<String, String> getArtifactProperties() {
            return Collections.emptyMap();
        }

        public ConfigResource[] getArtifactConfigResources() {
            return this.configResources;
        }

        public String getArtifactName() {
            return this.artifactDescriptor.getName();
        }

        public XmlConfigurationDocumentLoader getXmlConfigurationDocumentLoader() {
            return this.xmlConfigurationDocumentLoader;
        }

        public Set<ExtensionModel> getExtensions() {
            return this.extensionModels;
        }

        public XmlApplicationParser getXmlApplicationParser() {
            return this.xmlApplicationParser;
        }

        public ClassLoader getExecutionClassLoader() {
            return this.regionClassLoader;
        }
    }

    private class EmptyConfigurationProperties
    implements ConfigurationProperties {
        private EmptyConfigurationProperties() {
        }

        public <T> Optional<T> resolveProperty(String s) {
            return Optional.of("");
        }

        public Optional<Boolean> resolveBooleanProperty(String s) {
            return Optional.of(false);
        }

        public Optional<String> resolveStringProperty(String s) {
            return Optional.of("");
        }
    }
}

