/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.datasense.enrichment.model.IdComponentModelSelector;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.ImmutableMetadataResult;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.action.DispacheableAction;
import org.mule.tooling.client.internal.serialization.KryoFactory;
import org.mule.tooling.client.internal.serialization.Serializer;

public class ToolingMetadataServiceAdapter
implements MetadataService,
Command {
    private LazyValue<ApplicationModel> applicationModel;
    private LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentConfiguration>> componentLocator;
    private LazyValue<MetadataCacheIdGenerator<ComponentConfiguration>> metadataCacheIdGenerator;
    private MetadataProvider metadataProvider;
    private LazyValue<MetadataCache> metadataCache;
    private Map<String, String> toolingArtifactProperties;
    private Kryo kryo;
    private Serializer serializer;

    public ToolingMetadataServiceAdapter(LazyValue<ApplicationModel> applicationModel, LazyValue<Set<ExtensionModel>> extensionModels, MetadataProvider metadataProvider, LazyValue<MetadataCache> metadataCache, Map<String, String> toolingArtifactProperties, Serializer serializer) {
        com.google.common.base.Preconditions.checkNotNull(applicationModel, (Object)"applicationModel cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        com.google.common.base.Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull(toolingArtifactProperties, (Object)"toolingArtifactProperties, cannot be null");
        this.applicationModel = applicationModel;
        this.metadataProvider = metadataProvider;
        this.metadataCache = metadataCache;
        this.toolingArtifactProperties = toolingArtifactProperties;
        this.serializer = serializer;
        this.kryo = KryoFactory.createKryo();
        this.componentLocator = new LazyValue(() -> {
            HashMap components = new HashMap();
            ((ApplicationModel)applicationModel.get()).executeOnEveryComponentTree(componentModel -> {
                if (componentModel.getComponentLocation() != null) {
                    components.put(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)componentModel.getComponentLocation().getLocation()).build(), componentModel);
                }
            });
            return location -> Optional.ofNullable(components.get(location)).map(componentModel -> componentModel.getConfiguration());
        });
        this.metadataCacheIdGenerator = new LazyValue(() -> new ModelBasedMetadataCacheIdGeneratorFactory().create(DslResolvingContext.getDefault((Set)((Set)extensionModels.get())), (MetadataCacheIdGeneratorFactory.ComponentLocator)this.componentLocator.get()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String serialize(Object object) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                this.kryo.writeClassAndObject(output, object);
            }
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new ToolingException("Error while creating object from serialization", (Throwable)e);
        }
    }

    public <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = this.kryo.readClassAndObject(input);
            return (T)object;
        }
    }

    public org.mule.tooling.client.api.metadata.MetadataResult<org.mule.tooling.client.api.metadata.MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException {
        MetadataResult metadataKeys;
        Optional<ComponentModel> componentModel = this.findComponentModel((ApplicationModel)this.applicationModel.get(), metadataKeysRequest.getLocation());
        if (!componentModel.isPresent()) {
            metadataKeys = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("No object found at location %s", metadataKeysRequest.getLocation().toString())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onKeys()});
        } else {
            String componentId = IdComponentModelSelector.getComponentId((ComponentModel)componentModel.get());
            metadataKeys = (MetadataResult)this.deserialize((String)((Object)((MetadataCache)this.metadataCache.get()).getMetadataKeys((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, metadataKeysRequest.getLocation().toString(), null, this.toolingArtifactProperties), () -> {
                MetadataResult<MetadataKeysContainer> runtimeMetadataResult = this.metadataProvider.getMetadataKeys(metadataKeysRequest);
                List<Object> failures = Collections.emptyList();
                if (!runtimeMetadataResult.isSuccess()) {
                    failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
                }
                return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.serialize(runtimeMetadataResult)), failures);
            })));
        }
        return MetadataPartsFactory.toMetadataResultDTO(metadataKeys, () -> MetadataPartsFactory.toMetadataKeysContainerDTO((MetadataKeysContainer)metadataKeys.get()));
    }

    private Optional<ComponentModel> findComponentModel(ApplicationModel applicationModel, Location location) {
        Reference foundComponentModelReference = new Reference();
        Optional globalComponent = applicationModel.findTopLevelNamedComponent(location.getGlobalName());
        globalComponent.ifPresent(componentModel -> this.findComponentWithLocation((ComponentModel)componentModel, location).ifPresent(foundComponentModel -> {
            ComponentModel cfr_ignored_0 = (ComponentModel)foundComponentModelReference.set(foundComponentModel);
        }));
        return Optional.ofNullable(foundComponentModelReference.get());
    }

    private Optional<ComponentModel> findComponentWithLocation(ComponentModel componentModel, Location location) {
        if (componentModel.getComponentLocation().getLocation().equals(location.toString())) {
            return Optional.of(componentModel);
        }
        for (ComponentModel childComponent : componentModel.getInnerComponents()) {
            Optional<ComponentModel> foundComponent = this.findComponentWithLocation(childComponent, location);
            if (!foundComponent.isPresent()) continue;
            return foundComponent;
        }
        return Optional.empty();
    }

    public Feature<Action<Location>> disposeMetadataCache() {
        return Feature.enabled(new DispacheableAction<Location>(location -> ((MetadataCacheIdGeneratorFactory.ComponentLocator)this.componentLocator.get()).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location.toString()).build()).ifPresent(componentConfiguration -> ((MetadataCacheIdGenerator)this.metadataCacheIdGenerator.get()).getIdForGlobalMetadata(componentConfiguration).ifPresent(metadataCacheId -> this.metadataProvider.disposeMetadataCache(metadataCacheId.getValue()))), Location.class, this.serializer));
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getMetadataKeys": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(MetadataKeysRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize(this.getMetadataKeys((MetadataKeysRequest)this.serializer.deserialize(arguments[0])));
            }
            case "disposeMetadataCache": {
                return this.disposeMetadataCache();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

