/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.serialization.DefaultArrayTypeSerializer;
import org.mule.tooling.client.internal.serialization.KryoFactory;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapReader;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapWriter;

public class KryoServerSerializer
implements Serializer {
    public static String NAME = "kryo";
    private ClassLoader targetClassLoader;
    private List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient;

    public KryoServerSerializer(ClassLoader targetClassLoader) {
        this.targetClassLoader = targetClassLoader;
        this.typeAnnotationsNotSupportedByToolingRuntimeClient = Collections.synchronizedList(new ArrayList());
    }

    private static Kryo createKryo(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotsupportedByToolingRuntimeClient) {
        Kryo kryo = KryoFactory.createKryo();
        kryo.addDefaultSerializer(DefaultArrayType.class, (com.esotericsoftware.kryo.Serializer)new DefaultArrayTypeSerializer());
        kryo.register(LinkedHashMap.class, (com.esotericsoftware.kryo.Serializer)new TypeAnnotationsMapSerializer(targetClassLoader, typeAnnotationsNotsupportedByToolingRuntimeClient));
        return kryo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String serialize(Object object) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                KryoServerSerializer.createKryo(this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient).writeClassAndObject(output, object);
            }
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new ToolingException("Error while creating object from serialization", (Throwable)e);
        }
    }

    public <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = KryoServerSerializer.createKryo(this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient).readClassAndObject(input);
            return (T)object;
        }
    }

    private static class TypeAnnotationsMapSerializer
    extends MapSerializer {
        private TypeAnnotationMapWriter typeAnnotationMapWriter;
        private TypeAnnotationMapReader typeAnnotationMapReader;

        public TypeAnnotationsMapSerializer(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient) {
            this.typeAnnotationMapWriter = new TypeAnnotationMapWriter(targetClassLoader, typeAnnotationsNotSupportedByToolingRuntimeClient);
            this.typeAnnotationMapReader = new TypeAnnotationMapReader();
        }

        public void write(Kryo kryo, Output output, Map map) {
            super.write(kryo, output, this.typeAnnotationMapWriter.write(map));
        }

        public Map read(Kryo kryo, Input input, Class<Map> type) {
            Map original = super.read(kryo, input, type);
            return this.typeAnnotationMapReader.read(original);
        }
    }
}

