/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.tooling.client.api.component.location.Location;

import java.util.LinkedList;
import java.util.List;

public class LocationFactory {

  public static Location toLocationDTO(org.mule.runtime.api.component.location.Location location) {
    if (location == null) {
      return null;
    }
    String global = location.getGlobalName();
    List<String> rest = location.getParts();

    LinkedList<String> parts = new LinkedList<>();
    parts.add(global);
    parts.addAll(rest);

    return new Location(parts);
  }

  public static org.mule.runtime.api.component.location.Location fromLocationDTO(Location location) {
    if (location == null) {
      return null;
    }

    return org.mule.runtime.api.component.location.Location.builderFromStringRepresentation(location.toString()).build();
  }

}
