/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.dataweave;

import static java.util.Optional.of;
import static org.mule.runtime.api.el.BindingContextUtils.ERROR;
import static org.mule.runtime.api.metadata.DataType.BOOLEAN;
import static org.mule.runtime.api.metadata.DataType.STRING;
import static org.mule.runtime.api.metadata.DataType.fromType;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * Function that mocks the runtime behaviour when running DataWeave locally.
 *
 * @since 4.0.1
 */
public class MockCausedByFunction implements ExpressionFunction {

  @Override
  public Object call(Object[] parameters, BindingContext context) {
    return true;
  }

  @Override
  public Optional<DataType> returnType() {
    return of(BOOLEAN);
  }

  @Override
  public List<FunctionParameter> parameters() {
    return Arrays.asList(new FunctionParameter("error", fromType(Error.class), context -> context.lookup(ERROR).orElse(null)),
                         new FunctionParameter("type", STRING));
  }

}
