/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingApplicationModel {
    private static final String TOOLING_CLIENT_ALLOW_ACCESS_EXTERNAL_RESOURCES = "tooling.client.configuration.allowAccessExternalResources";
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolingApplicationModel.class);
    private ToolingApplicationModel parent;
    private ApplicationModel muleApplicationModel;
    private ClassLoader classLoader;

    public ToolingApplicationModel(ToolingApplicationModel parent, ApplicationModel muleApplicationModel, ClassLoader classLoader) {
        Objects.requireNonNull(muleApplicationModel, "muleApplicationModel cannot be null");
        Objects.requireNonNull(muleApplicationModel, "muleApplicationModel cannot be null");
        this.parent = parent;
        this.muleApplicationModel = muleApplicationModel;
        this.classLoader = classLoader;
    }

    public Optional<ToolingApplicationModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ApplicationModel getMuleApplicationModel() {
        return this.muleApplicationModel;
    }

    public Optional<URI> findResource(String resource) {
        URI uri = URI.create(resource);
        if (uri.getScheme() == null || uri.getScheme().equalsIgnoreCase("resource")) {
            try {
                URL classLoaderResource = this.classLoader.getResource(resource);
                if (classLoaderResource != null) {
                    return Optional.ofNullable(classLoaderResource.toURI());
                }
                return Optional.empty();
            }
            catch (URISyntaxException e) {
                return Optional.empty();
            }
        }
        if (Boolean.valueOf(System.getProperty(TOOLING_CLIENT_ALLOW_ACCESS_EXTERNAL_RESOURCES, "false")).booleanValue()) {
            return Optional.of(uri);
        }
        LOGGER.warn("Trying to access an external resources '{}' when Tooling Client is not enabled to access external resources, use the system properties '{}' to enable it ", (Object)resource, (Object)TOOLING_CLIENT_ALLOW_ACCESS_EXTERNAL_RESOURCES);
        return Optional.empty();
    }
}

