/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.action;

import static java.lang.String.format;
import static org.mule.runtime.api.util.Preconditions.checkState;
import static org.mule.tooling.client.internal.Command.methodNotFound;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DispacheableAction<T> implements Action<T>, Command {

  private Action<T> delegate;
  private Class<T> actionType;
  private Serializer serializer;

  public DispacheableAction(Action<T> delegate, Class<T> actionType, Serializer serializer) {
    this.delegate = delegate;
    this.actionType = actionType;
    this.serializer = serializer;
  }

  @Override
  public void perform(T t) {
    delegate.perform(t);
  }

  @Override
  public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
    if (methodName.equals("perform")) {
      checkState(arguments.length == 1,
                 format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
      checkState(classes.length == 1 && classes[0].equals(actionType.getName()),
                 format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
      perform(serializer.deserialize(arguments[0]));
      return null;
    }
    throw methodNotFound(this.getClass(), methodName);
  }
}
