/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.service;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.internal.artifact.ServiceDescriptorFactory;

public class ToolingFileSystemServiceProviderDiscoverer
implements ServiceProviderDiscoverer {
    private final ArtifactClassLoader apiClassLoader;
    private final ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory;
    private final DescriptorLoaderRepository descriptorLoaderRepository;
    private final ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder;
    private final File targetServicesFolder;

    public ToolingFileSystemServiceProviderDiscoverer(ArtifactClassLoader containerClassLoader, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder, File targetServicesFolder) {
        Preconditions.checkArgument((containerClassLoader != null ? 1 : 0) != 0, (String)"containerClassLoader cannot be null");
        Preconditions.checkArgument((serviceClassLoaderFactory != null ? 1 : 0) != 0, (String)"serviceClassLoaderFactory cannot be null");
        Preconditions.checkArgument((artifactDescriptorValidatorBuilder != null ? 1 : 0) != 0, (String)"artifactDescriptorValidatorBuilder cannot be null");
        Preconditions.checkArgument((targetServicesFolder != null ? 1 : 0) != 0, (String)"targetServicesFolder cannot be null");
        this.descriptorLoaderRepository = descriptorLoaderRepository;
        this.apiClassLoader = containerClassLoader;
        this.serviceClassLoaderFactory = serviceClassLoaderFactory;
        this.artifactDescriptorValidatorBuilder = artifactDescriptorValidatorBuilder;
        this.targetServicesFolder = targetServicesFolder;
    }

    public List<Pair<ArtifactClassLoader, ServiceProvider>> discover() throws ServiceResolutionError {
        ServiceDescriptorFactory serviceDescriptorFactory = new ServiceDescriptorFactory(this.descriptorLoaderRepository, this.artifactDescriptorValidatorBuilder);
        LinkedList<ServiceDescriptor> serviceDescriptors = new LinkedList<ServiceDescriptor>();
        serviceDescriptors.addAll(this.getServiceDescriptors(serviceDescriptorFactory));
        return this.createServiceProviders(serviceDescriptors, this.serviceClassLoaderFactory);
    }

    private List<ServiceDescriptor> getServiceDescriptors(ServiceDescriptorFactory serviceDescriptorFactory) {
        LinkedList<ServiceDescriptor> foundServices = new LinkedList<ServiceDescriptor>();
        for (File serviceFolder : this.targetServicesFolder.listFiles()) {
            ServiceDescriptor serviceDescriptor = serviceDescriptorFactory.create(serviceFolder, Optional.empty());
            foundServices.add(serviceDescriptor);
        }
        return foundServices;
    }

    private List<Pair<ArtifactClassLoader, ServiceProvider>> createServiceProviders(List<ServiceDescriptor> serviceDescriptors, ArtifactClassLoaderFactory<ServiceDescriptor> serviceClassLoaderFactory) throws ServiceResolutionError {
        LinkedList<Pair<ArtifactClassLoader, ServiceProvider>> serviceProviders = new LinkedList<Pair<ArtifactClassLoader, ServiceProvider>>();
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            ArtifactClassLoader serviceClassLoader = serviceClassLoaderFactory.create(this.getServiceArtifactId(serviceDescriptor), (ArtifactDescriptor)serviceDescriptor, this.apiClassLoader.getClassLoader(), this.apiClassLoader.getClassLoaderLookupPolicy());
            ServiceProvider serviceProvider = this.instantiateServiceProvider(serviceClassLoader.getClassLoader(), serviceDescriptor.getServiceProviderClassName());
            serviceProviders.add((Pair<ArtifactClassLoader, ServiceProvider>)new Pair((Object)serviceClassLoader, (Object)serviceProvider));
        }
        return serviceProviders;
    }

    private String getServiceArtifactId(ServiceDescriptor serviceDescriptor) {
        return "service/" + serviceDescriptor.getName();
    }

    private ServiceProvider instantiateServiceProvider(ClassLoader classLoader, String className) throws ServiceResolutionError {
        Object reflectedObject;
        try {
            reflectedObject = ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> {
                try {
                    return ClassUtils.instantiateClass((String)className, (Object[])new Object[0]);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to create service from class: " + className)), (Throwable)e);
                }
            });
        }
        catch (RuntimeException e) {
            throw new ServiceResolutionError(e.getMessage());
        }
        if (!(reflectedObject instanceof ServiceProvider)) {
            throw new ServiceResolutionError(String.format("Provided service class '%s' does not implement '%s'", className, ServiceProvider.class.getName()));
        }
        return (ServiceProvider)reflectedObject;
    }
}

