/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

import java.io.File;
import java.util.List;
import java.util.Optional;

public interface InternalExtensionModelService {

  /**
   * Loads the {@link ExtensionModel} for the given plugin.
   *
   * @param pluginDescriptor {@link BundleDescriptor} referencing to the plugin artifact.
   * @return {@link ExtensionModel} for the plugin or {@link Optional#empty()} if the plugin doesn't have an {@link ExtensionModel}.
   */
  Optional<LoadedExtensionInformation> loadExtensionData(BundleDescriptor pluginDescriptor);

  /**
   * Loads the {@link ExtensionModel} for the given plugin.
   *
   * @param pluginDescriptor {@link BundleDescriptor} referencing to the plugin artifact.
   * @return {@link ExtensionModel} for the plugin or {@link Optional#empty()} if the plugin doesn't have an {@link ExtensionModel}.
   */
  Optional<LoadedExtensionInformation> loadExtensionData(BundleDescriptor pluginDescriptor, File pluginJarFile);

  /**
   * Loads the {@link ExtensionModel} for Mule Runtime core components.
   *
   * @return {@link ExtensionModel} for Mule Runtime core components.
   */
  List<ExtensionModel> loadRuntimeExtensionModels();

  /**
   * Loads the {@link ArtifactPluginDescriptor} for the given plugin.
   *
   * @param pluginFile {@link File} referencing to the plugin artifact file (packaged or exploded).
   * @return {@link ArtifactPluginDescriptor} for the plugin along with its class loader.
   */
  ArtifactPluginDescriptor readBundleDescriptor(File pluginFile);

}
