/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import static java.util.stream.Collectors.toSet;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MetadataPartsFactory {

  public static org.mule.tooling.client.api.metadata.MetadataKey metadataKeyToDTO(MetadataKey metadataKey) {
    if (metadataKey == null) {
      return null;
    }
    Set<org.mule.tooling.client.api.metadata.MetadataKey> children =
        metadataKey.getChilds().stream().map(MetadataPartsFactory::metadataKeyToDTO).collect(toSet());

    return new org.mule.tooling.client.api.metadata.MetadataKey(metadataKey.getId(), metadataKey.getDisplayName(),
                                                                children, metadataKey.getPartName());
  }

  public static org.mule.tooling.client.api.metadata.MetadataKeysContainer toMetadataKeysContainerDTO(MetadataKeysContainer container) {
    Map<String, Set<MetadataKey>> map = container.getKeysByCategory();

    Map<String, Set<org.mule.tooling.client.api.metadata.MetadataKey>> dtomap = new HashMap<>();

    for (String key : map.keySet()) {
      Set<org.mule.tooling.client.api.metadata.MetadataKey> set =
          map.get(key).stream().map(MetadataPartsFactory::metadataKeyToDTO).collect(toSet());
      dtomap.put(key, set);
    }
    return new org.mule.tooling.client.api.metadata.MetadataKeysContainer(dtomap);
  }

  public static org.mule.tooling.client.api.metadata.MetadataComponent toMetadataComponentDTO(MetadataComponent component) {
    if (component == MetadataComponent.COMPONENT) {
      return org.mule.tooling.client.api.metadata.MetadataComponent.componentMetadataComponent(component.name());
    }
    if (component == MetadataComponent.KEYS) {
      return org.mule.tooling.client.api.metadata.MetadataComponent.keysMetadataComponent(component.name());
    }
    if (component == MetadataComponent.ENTITY) {
      return org.mule.tooling.client.api.metadata.MetadataComponent.entityMetadataComponent(component.name());
    }
    if (component == MetadataComponent.INPUT) {
      return org.mule.tooling.client.api.metadata.MetadataComponent.inputMetadataComponent(component.name());
    }
    if (component == MetadataComponent.OUTPUT_ATTRIBUTES) {
      return org.mule.tooling.client.api.metadata.MetadataComponent.outputAttributesMetadataComponent(component.name());
    }
    if (component == MetadataComponent.OUTPUT_PAYLOAD) {
      return org.mule.tooling.client.api.metadata.MetadataComponent.outputPayloadMetadataComponent(component.name());
    }
    return new org.mule.tooling.client.api.metadata.MetadataComponent(component.name());
  }

  public static org.mule.tooling.client.api.metadata.FailureCode failureCodeToDTO(FailureCode failureCode) {
    if (failureCode.equals(FailureCode.CONNECTION_FAILURE)) {
      return org.mule.tooling.client.api.metadata.FailureCode.connectionFailureFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.APPLICATION_NOT_FOUND)) {
      return org.mule.tooling.client.api.metadata.FailureCode.applicationNotFoundFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.COMPONENT_NOT_FOUND)) {
      return org.mule.tooling.client.api.metadata.FailureCode.componentNotFoundFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.INVALID_CONFIGURATION)) {
      return org.mule.tooling.client.api.metadata.FailureCode.invalidConfigurationFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.INVALID_CREDENTIALS)) {
      return org.mule.tooling.client.api.metadata.FailureCode.invalidCredentialsFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.INVALID_METADATA_KEY)) {
      return org.mule.tooling.client.api.metadata.FailureCode.invalidMetadataKetFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.NO_DYNAMIC_KEY_AVAILABLE)) {
      return org.mule.tooling.client.api.metadata.FailureCode.noDynamicKeyAvailableFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE)) {
      return org.mule.tooling.client.api.metadata.FailureCode.noDynamicMetadataAvailableFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE)) {
      return org.mule.tooling.client.api.metadata.FailureCode.noDynamicTypeAvailableFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.NONE)) {
      return org.mule.tooling.client.api.metadata.FailureCode.noneFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.NOT_AUTHORIZED)) {
      return org.mule.tooling.client.api.metadata.FailureCode.notAuthorizedFailureCode(failureCode.getName());
    }
    if (failureCode.equals(FailureCode.RESOURCE_UNAVAILABLE)) {
      return org.mule.tooling.client.api.metadata.FailureCode.resourceUnavailableFailureCode(failureCode.getName());
    }
    return new org.mule.tooling.client.api.metadata.FailureCode(failureCode.getName());
  }

  public static org.mule.tooling.client.api.metadata.MetadataResult toMetadataResultDTO(MetadataResult result,
                                                                                        Supplier<Object> supplier) {
    if (result.isSuccess()) {
      return org.mule.tooling.client.api.metadata.MetadataResult.success(supplier.get());
    } else {
      List<MetadataFailure> failures = result.getFailures();

      return org.mule.tooling.client.api.metadata.MetadataResult
          .failure(toMetadataFailuresDTO(failures));
    }
  }

  public static List<org.mule.tooling.client.api.metadata.MetadataFailure> toMetadataFailuresDTO(List<MetadataFailure> failures) {
    return failures.stream()
        .map(failure -> new org.mule.tooling.client.api.metadata.MetadataFailure(toMetadataComponentDTO(failure
            .getFailingComponent()),
                                                                                 failure
                                                                                     .getFailingElement()
                                                                                     .orElse(""),
                                                                                 failure
                                                                                     .getMessage(),
                                                                                 failure
                                                                                     .getReason(),
                                                                                 failureCodeToDTO(failure
                                                                                     .getFailureCode())))
        .collect(Collectors.toList());
  }

}
