/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.ExtensionModelFactory;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.util.Preconditions;

public class ToolingExtensionModelAdapter
implements ExtensionModelService,
Command {
    private MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private Serializer serializer;

    public ToolingExtensionModelAdapter(MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, Serializer serializer) {
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
        this.serializer = serializer;
    }

    public Optional<org.mule.tooling.client.api.extension.model.ExtensionModel> loadExtensionModel(ArtifactDescriptor pluginDescriptor) {
        return this.muleRuntimeExtensionModelProvider.getExtensionModel(pluginDescriptor).map(runtimeExtensionModel -> this.toDTO((ExtensionModel)runtimeExtensionModel, this.muleRuntimeExtensionModelProvider.getMinMuleVersion(pluginDescriptor).get()));
    }

    public Optional<org.mule.tooling.client.api.extension.model.ExtensionModel> loadExtensionModel(File plugin) {
        return this.muleRuntimeExtensionModelProvider.getExtensionModel(plugin).map(runtimeExtensionModel -> this.toDTO((ExtensionModel)runtimeExtensionModel, this.muleRuntimeExtensionModelProvider.getMinMuleVersion(plugin).get()));
    }

    public Optional<String> loadExtensionSchema(ArtifactDescriptor pluginDescriptor) {
        return this.muleRuntimeExtensionModelProvider.getExtensionSchema(pluginDescriptor);
    }

    public Optional<String> loadExtensionSchema(File plugin) {
        return this.muleRuntimeExtensionModelProvider.getExtensionSchema(plugin);
    }

    public List<org.mule.tooling.client.api.extension.model.ExtensionModel> loadMuleExtensionModels() {
        return this.muleRuntimeExtensionModelProvider.getRuntimeExtensionModels().stream().map(runtimeExtensionModel -> this.toDTO((ExtensionModel)runtimeExtensionModel, runtimeExtensionModel.getVersion())).collect(Collectors.toList());
    }

    private org.mule.tooling.client.api.extension.model.ExtensionModel toDTO(ExtensionModel runtimeExtensionModel, String minMuleVersion) {
        return new ExtensionModelFactory().createExtensionModel(runtimeExtensionModel, minMuleVersion);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "loadExtensionModel": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                String argClazz = classes[0];
                Preconditions.checkState((classes.length == 1 && (argClazz.equals(ArtifactDescriptor.class.getName()) || argClazz.equals(File.class.getName())) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                if (argClazz.equals(ArtifactDescriptor.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionModel((ArtifactDescriptor)this.serializer.deserialize(arguments[0])));
                }
                if (argClazz.equals(File.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionModel((File)this.serializer.deserialize(arguments[0])));
                }
            }
            case "loadExtensionSchema": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                String argClazz = classes[0];
                Preconditions.checkState((classes.length == 1 && (argClazz.equals(ArtifactDescriptor.class.getName()) || argClazz.equals(File.class.getName())) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                if (argClazz.equals(ArtifactDescriptor.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionSchema((ArtifactDescriptor)this.serializer.deserialize(arguments[0])));
                }
                if (argClazz.equals(File.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionSchema((File)this.serializer.deserialize(arguments[0])));
                }
            }
            case "loadMuleExtensionModels": {
                return this.serializer.serialize(this.loadMuleExtensionModels());
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

