/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import java.nio.charset.Charset;
import java.util.Map;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunner;
import org.mule.tooling.event.model.DataTypeModel;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.weave.v2.runtime.utils.WeaveRequirementsChecker;

public class DataWeaveRunnerProvider {
    private static final String DW_MEDIA_TYPE = "application/dw";
    private DataWeaveRunner localRunner;
    private final WeaveRequirementsChecker requirementsChecker = new WeaveRequirementsChecker();
    private DataWeaveRunner remoteRunner;

    public DataWeaveRunnerProvider(DataWeaveRunner localRunner, DataWeaveRunner remoteRunner) {
        this.localRunner = localRunner;
        this.remoteRunner = remoteRunner;
    }

    public DataWeaveRunner getRunner(DataWeavePreviewRequest parameters) {
        return this.getRunner(parameters.getScript(), parameters.getEvent());
    }

    private DataWeaveRunner getRunner(String script, EventModel event) {
        if (this.requirementsChecker.requiresJava(script) || this.parametersRequiresJava(event)) {
            return this.getRemoteRunner();
        }
        return this.getLocalRunner();
    }

    private boolean parametersRequiresJava(EventModel model) {
        if (model != null) {
            if (this.messageRequiresJava(model.getMessage())) {
                return true;
            }
            if (this.variablesRequiresJava(model)) {
                return true;
            }
        }
        return false;
    }

    private boolean variablesRequiresJava(EventModel model) {
        boolean anyRequiresJava;
        Map variables = model.getVariables();
        return variables != null && !variables.isEmpty() && (anyRequiresJava = variables.entrySet().stream().anyMatch(entry -> this.isJavaBased((TypedValueModel)entry.getValue())));
    }

    private boolean messageRequiresJava(MessageModel message) {
        if (message != null) {
            TypedValueModel payload = message.getPayload();
            if (payload != null && this.isJavaBased(payload)) {
                return true;
            }
            TypedValueModel attributes = message.getAttributes();
            if (attributes != null && this.isJavaBased(attributes)) {
                return true;
            }
        }
        return false;
    }

    private boolean isJavaBased(TypedValueModel typedValueModel) {
        DataTypeModel dataType = typedValueModel.getDataType();
        String mediaTypeModel = dataType.getMediaType();
        MediaType mediaType = MediaType.parse((String)mediaTypeModel);
        Charset charset = mediaType.getCharset().orElseGet(Charset::defaultCharset);
        return DW_MEDIA_TYPE.equals(mediaType.getPrimaryType()) && new WeaveRequirementsChecker().requiresJava(new String(typedValueModel.getContent(), charset));
    }

    public DataWeaveRunner getLocalRunner() {
        return this.localRunner;
    }

    public DataWeaveRunner getRemoteRunner() {
        return this.remoteRunner;
    }
}

