/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.datasense;

import static java.util.Optional.empty;
import static java.util.Optional.of;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.Optional;

/**
 * Utility methods for {@link org.mule.runtime.config.internal.model.ApplicationModel}.
 *
 * @since 4.1
 */
public final class ApplicationModelUtils {

  private ApplicationModelUtils() {}

  public static Optional<ComponentModel> findComponentWithLocation(ComponentModel componentModel, Location location) {
    if (componentModel.getComponentLocation() != null
        && componentModel.getComponentLocation().getLocation().equals(location.toString())) {
      return of(componentModel);
    }
    for (ComponentModel childComponent : componentModel.getInnerComponents()) {
      Optional<ComponentModel> foundComponent = findComponentWithLocation(childComponent, location);
      if (foundComponent.isPresent()) {
        return foundComponent;
      }
    }
    return empty();
  }

}
