/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.mule.tooling.client.api.feature.Feature;

public interface Command {
    public Object invokeMethod(String var1, String[] var2, String[] var3);

    default public boolean isFeatureEnabled(String methodName, String[] classes) {
        Class[] parameterTypes = Arrays.stream(classes).map(argClass -> {
            try {
                return this.getClass().getClassLoader().loadClass((String)argClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Feature '%s' is not supported with calling argument of type '%s'", methodName, argClass));
            }
        }).collect(Collectors.toList()).toArray(new Class[0]);
        try {
            Method method = this.getClass().getMethod(methodName, parameterTypes);
            if (!method.getReturnType().isAssignableFrom(Feature.class)) {
                throw new IllegalArgumentException(String.format("Method '%s' is not a Feature", methodName));
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static RuntimeException methodNotFound(Class<? extends Command> clazz, String methodName) {
        return new IllegalArgumentException(String.format("Method '%s' not found on '%s'", methodName, clazz));
    }

    public static RuntimeException notMatchingMethod(Class<? extends Command> clazz, String methodName, String[] classes) {
        return new IllegalArgumentException(String.format("Method '%s' not found on '%s' for parameter types '%s'", methodName, clazz, Arrays.toString(classes)));
    }
}

