/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.deployment.model.internal.tooling.ToolingDomainClassLoaderBuilder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;

public class DomainClassLoaderFactory {
    private ArtifactClassLoader containerArtifactClassLoader;
    private RegionPluginClassLoadersFactory regionPluginClassLoadersFactory;
    private PluginDependenciesResolver pluginDependenciesResolver;

    public DomainClassLoaderFactory(ArtifactClassLoader containerArtifactClassLoader, RegionPluginClassLoadersFactory regionPluginClassLoadersFactory, PluginDependenciesResolver pluginDependenciesResolver) {
        Objects.requireNonNull(containerArtifactClassLoader, "containerArtifactClassLoader cannot be null");
        Objects.requireNonNull(regionPluginClassLoadersFactory, "regionPluginClassLoadersFactory cannot be null");
        Objects.requireNonNull(pluginDependenciesResolver, "pluginDependenciesResolver cannot be null");
        this.containerArtifactClassLoader = containerArtifactClassLoader;
        this.regionPluginClassLoadersFactory = regionPluginClassLoadersFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
    }

    public ToolingArtifactClassLoader createDomainClassLoader(DomainDescriptor domainDescriptor) {
        try {
            ToolingDomainClassLoaderBuilder domainClassLoaderBuilder = new ToolingDomainClassLoaderBuilder(this.containerArtifactClassLoader, (DeployableArtifactClassLoaderFactory)new org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory(this.containerArtifactClassLoader.getClassLoader()), this.regionPluginClassLoadersFactory);
            domainClassLoaderBuilder.setArtifactDescriptor((ArtifactDescriptor)domainDescriptor);
            List resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(Collections.emptySet(), (List)ImmutableList.builder().addAll((Iterable)domainDescriptor.getPlugins()).build(), true);
            resolvedArtifactPluginDescriptors.stream().forEach(xva$0 -> domainClassLoaderBuilder.addArtifactPluginDescriptors(new ArtifactPluginDescriptor[]{xva$0}));
            return domainClassLoaderBuilder.build();
        }
        catch (IOException e) {
            throw new ToolingException("Error while creating domain class loader", (Throwable)e);
        }
    }
}

