/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.dataweave;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;

import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;

/**
 * {@link DataWeaveRunner} remote runner implementation for applications.
 *
 * @since 4.1
 */
public class ApplicationRemoteRunner extends AbstractRemoteRunner {

  private RemoteApplicationInvoker remoteApplicationInvoker;

  /**
   * Creates an instance of the application runner.
   *
   * @param remoteApplicationInvoker the invoker to call Mule Runtime service. Non null.
   */
  public ApplicationRemoteRunner(RemoteApplicationInvoker remoteApplicationInvoker) {
    requireNonNull(remoteApplicationInvoker, "remoteApplicationInvoker cannot be null");

    this.remoteApplicationInvoker = remoteApplicationInvoker;
  }

  @Override
  protected PreviewResponse doExecute(PreviewRequest request) {
    return remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService
        .runDataWeaveApplication(applicationId, request));
  }
}
