/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.api.metadata.resolving.FailureCode.APPLICATION_NOT_FOUND;
import static org.mule.runtime.api.metadata.resolving.FailureCode.COMPONENT_NOT_FOUND;
import static org.mule.runtime.api.metadata.resolving.FailureCode.CONNECTION_FAILURE;
import static org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_CONFIGURATION;
import static org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_CREDENTIALS;
import static org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_METADATA_KEY;
import static org.mule.runtime.api.metadata.resolving.FailureCode.NONE;
import static org.mule.runtime.api.metadata.resolving.FailureCode.NOT_AUTHORIZED;
import static org.mule.runtime.api.metadata.resolving.FailureCode.NO_DYNAMIC_KEY_AVAILABLE;
import static org.mule.runtime.api.metadata.resolving.FailureCode.NO_DYNAMIC_METADATA_AVAILABLE;
import static org.mule.runtime.api.metadata.resolving.FailureCode.NO_DYNAMIC_TYPE_AVAILABLE;
import static org.mule.runtime.api.metadata.resolving.FailureCode.RESOURCE_UNAVAILABLE;
import static org.mule.tooling.client.internal.MetadataPartsFactory.failureCodeToDTO;

import org.mule.runtime.api.metadata.resolving.FailureCode;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;

@Feature("DTOs")
@Story("Metadata Model for Tooling API")
public class MetadataPartsFactoryTestCase {

  public static final String THIS_IS_A_NEW_FAILURE_CODE = "this-is-a-new-failure-code";

  @Test
  public void failureCodes() {
    assertThat(failureCodeToDTO(INVALID_METADATA_KEY).isInvalidMetadataKet(), is(true));
    assertThat(failureCodeToDTO(APPLICATION_NOT_FOUND).isApplicationNotFound(), is(true));
    assertThat(failureCodeToDTO(COMPONENT_NOT_FOUND).isComponentNotFound(), is(true));
    assertThat(failureCodeToDTO(CONNECTION_FAILURE).isConnectionFailure(), is(true));
    assertThat(failureCodeToDTO(INVALID_CONFIGURATION).isInvalidConfiguration(), is(true));
    assertThat(failureCodeToDTO(INVALID_CREDENTIALS).isInvalidCredentials(), is(true));
    assertThat(failureCodeToDTO(NO_DYNAMIC_KEY_AVAILABLE).isNoDynamicKeyAvailable(), is(true));
    assertThat(failureCodeToDTO(NO_DYNAMIC_TYPE_AVAILABLE).isNoDynamicTypeAvailable(), is(true));
    assertThat(failureCodeToDTO(NONE).isNone(), is(true));
    assertThat(failureCodeToDTO(NOT_AUTHORIZED).isNotAuthorized(), is(true));
    assertThat(failureCodeToDTO(RESOURCE_UNAVAILABLE).isResourceUnavailable(), is(true));
    assertThat(failureCodeToDTO(NO_DYNAMIC_METADATA_AVAILABLE).isNoDynamicMetadataAvailable(), is(true));
  }

  @Test
  public void failureCodeUnknown() {
    FailureCode failureCode = new FailureCode(THIS_IS_A_NEW_FAILURE_CODE);
    assertThat(failureCodeToDTO(failureCode).isUnknown(), is(true));
    assertThat(failureCodeToDTO(failureCode).getValue(), is(THIS_IS_A_NEW_FAILURE_CODE));
  }

}
