/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Pair;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.ImmutableMetadataResult;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.LocationFactory;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.datasense.DataSenseArtifact;
import org.mule.tooling.client.internal.serialization.DefaultArrayTypeSerializer;
import org.mule.tooling.client.internal.serialization.KryoFactory;

public class DataSenseMetadataCacheAdapter
implements DataSenseMetadataCacheProvider {
    private DataSenseArtifact dataSenseArtifact;
    private Kryo kryo;

    public DataSenseMetadataCacheAdapter(DataSenseArtifact dataSenseArtifact) {
        this.dataSenseArtifact = dataSenseArtifact;
        this.kryo = KryoFactory.createKryo();
        this.kryo.addDefaultSerializer(DefaultArrayType.class, (Serializer)new DefaultArrayTypeSerializer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String serialize(Object object) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                this.kryo.writeClassAndObject(output, object);
            }
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new ToolingException("Error while creating object from serialization", (Throwable)e);
        }
    }

    public <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = this.kryo.readClassAndObject(input);
            return (T)object;
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String componentId, Location location, Long timestamp, Callable<MetadataResult<ComponentMetadataDescriptor<OperationModel>>> callable) {
        Pair<MetadataCache, Map<String, String>> input = this.getDataSenseCache(location);
        String result = (String)((Object)((MetadataCache)input.getFirst()).getOperationMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, (Map)input.getSecond()), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.serialize(runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.deserialize(result);
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String componentId, Location location, Long timestamp, Callable<MetadataResult<ComponentMetadataDescriptor<SourceModel>>> callable) {
        Pair<MetadataCache, Map<String, String>> input = this.getDataSenseCache(location);
        String result = (String)((Object)((MetadataCache)input.getFirst()).getSourceMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, (Map)input.getSecond()), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.serialize(runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.deserialize(result);
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(String componentId, Location location, Long timestamp, Callable<MetadataResult<MetadataKeysContainer>> callable) {
        Pair<MetadataCache, Map<String, String>> input = this.getDataSenseCache(location);
        String result = (String)((Object)((MetadataCache)input.getFirst()).getMetadataKeys((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(componentId, LocationFactory.toLocationDTO(location).toString(), timestamp, (Map)input.getSecond()), () -> {
            MetadataResult runtimeMetadataResult = (MetadataResult)callable.call();
            List<Object> failures = Collections.emptyList();
            if (!runtimeMetadataResult.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(runtimeMetadataResult.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(runtimeMetadataResult.isSuccess()), (Serializable)((Object)this.serialize(runtimeMetadataResult)), failures);
        }));
        return (MetadataResult)this.deserialize(result);
    }

    private Pair<MetadataCache, Map<String, String>> getDataSenseCache(Location location) {
        Pair input;
        if (this.dataSenseArtifact.getParent().isPresent() && this.dataSenseArtifact.getParent().get().hasComponentModel(location)) {
            DataSenseArtifact parent = this.dataSenseArtifact.getParent().get();
            input = new Pair((Object)parent.getMetadataCache(), parent.getProperties());
        } else {
            input = new Pair((Object)this.dataSenseArtifact.getMetadataCache(), this.dataSenseArtifact.getProperties());
        }
        return input;
    }
}

