/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.serialization;

import static org.mule.tooling.client.internal.serialization.TypeAnnotationMapWriter.isTypeAnnotationMap;
import static org.mule.tooling.client.internal.serialization.TypeAnnotationsTransformers.toolingTypeAnnotationTransformers;
import org.mule.metadata.api.annotation.TypeAnnotation;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Writer that transforms the {@link TypeAnnotation} from Tooling Runtime Client to Tooling API.
 *
 * @since 4.2.0
 */
public class TypeAnnotationMapReader {

  public Map read(Map original) {
    if (isTypeAnnotationMap(original)) {
      Map<Class, TypeAnnotation> transformed = new LinkedHashMap<>();
      original.forEach((key, typeAnnotation) -> {
        if (toolingTypeAnnotationTransformers.containsKey(key)) {
          TypeAnnotation tranformed = toolingTypeAnnotationTransformers.get(key).transform((TypeAnnotation) typeAnnotation);
          transformed.put(tranformed.getClass(), tranformed);
        } else {
          transformed.put((Class) key, (TypeAnnotation) typeAnnotation);
        }
      });
      return transformed;
    }
    return original;
  }

}
