/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.tooling.internal.DefaultToolingService;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.exception.ToolingArtifactNotFoundException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.icons.ExtensionIconsService;
import org.mule.tooling.client.api.message.history.MessageHistoryService;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultMessageHistoryService;
import org.mule.tooling.client.internal.DefaultToolingArtifact;
import org.mule.tooling.client.internal.DefaultToolingArtifactContext;
import org.mule.tooling.client.internal.DomainCache;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.NoOpMetadataCache;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.ToolingArtifactWrapper;
import org.mule.tooling.client.internal.ToolingExtensionModelAdapter;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.application.DefaultApplication;
import org.mule.tooling.client.internal.application.DefaultDomain;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.artifact.DefaultArtifactSerializationService;
import org.mule.tooling.client.internal.dsl.DefaultDslSyntaxResolverService;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.icons.DefaultExtensionIconsService;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.service.ServiceRegistry;

public class DefaultToolingRuntimeClient
implements ToolingRuntimeClient,
Command {
    private DefaultToolingArtifactContext context;
    private ExtensionModelService extensionModelService;
    private ArtifactSerializationService artifactSerializationService;
    private DslSyntaxResolverService dslSyntaxResolverService;
    private MessageHistoryService messageHistoryService;
    private ExtensionIconsService extensionIconsService;

    public DefaultToolingRuntimeClient(MavenClient mavenClient, Serializer serializer, Optional<AgentConfiguration> agentConfigurationOptional, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, MuleArtifactResourcesRegistry muleArtifactResourcesRegistry, ApplicationCache applicationCache, DomainCache domainCache, Optional<MetadataCacheFactory> metadataCacheFactoryOptional, DslSyntaxServiceCache dslSyntaxServiceCache, ServiceRegistry serviceRegistry) {
        com.google.common.base.Preconditions.checkNotNull((Object)mavenClient, (Object)"aetherDependencyResolver cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        com.google.common.base.Preconditions.checkNotNull(agentConfigurationOptional, (Object)"agentConfigurationOptional cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)muleRuntimeExtensionModelProvider, (Object)"muleRuntimeExtensionModelProvider cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)muleArtifactResourcesRegistry, (Object)"muleArtifactResourcesRegistry cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)applicationCache, (Object)"applicationCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)domainCache, (Object)"domainCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull(metadataCacheFactoryOptional, (Object)"metadataCacheFactoryOptional cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)dslSyntaxServiceCache, (Object)"dslSyntaxServiceCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)serviceRegistry, (Object)"serviceRegistry cannot be null");
        this.context = new DefaultToolingArtifactContext(muleArtifactResourcesRegistry);
        this.context.setAgentConfiguration(agentConfigurationOptional);
        this.context.setSerializer(serializer);
        this.context.setMavenClient(mavenClient);
        this.context.setMuleRuntimeExtensionModelProvider(muleRuntimeExtensionModelProvider);
        this.context.setApplicationCache(applicationCache);
        this.context.setDomainCache(domainCache);
        this.context.setMetadataCacheFactory(metadataCacheFactoryOptional);
        this.context.setServiceRegistry(serviceRegistry);
        this.extensionModelService = new ToolingExtensionModelAdapter(muleRuntimeExtensionModelProvider, this.context.getSerializer());
        this.artifactSerializationService = new DefaultArtifactSerializationService(muleRuntimeExtensionModelProvider.getRuntimeExtensionModels(), muleRuntimeExtensionModelProvider, mavenClient, this.context.getSerializer());
        this.messageHistoryService = new DefaultMessageHistoryService((LazyValue<RuntimeToolingService>)new LazyValue(() -> this.context.getRuntimeToolingService()), this.context.getSerializer());
        this.extensionModelService = new ToolingExtensionModelAdapter(muleRuntimeExtensionModelProvider, this.context.getSerializer());
        this.extensionIconsService = new DefaultExtensionIconsService(this.context.getMavenClient(), this.context.getSerializer());
        this.dslSyntaxResolverService = new DefaultDslSyntaxResolverService(dslSyntaxServiceCache, mavenClient, muleRuntimeExtensionModelProvider, this.context.getSerializer());
    }

    public ExtensionModelService extensionModelService() {
        return this.extensionModelService;
    }

    public ArtifactSerializationService artifactSerializationService() {
        return this.artifactSerializationService;
    }

    public DslSyntaxResolverService dslSyntaxResolverService() {
        return this.dslSyntaxResolverService;
    }

    public MessageHistoryService messageHistoryService() {
        return this.messageHistoryService;
    }

    public ExtensionIconsService iconsService() {
        return this.extensionIconsService;
    }

    public ToolingArtifact newToolingArtifact(URL artifactUrlContent, Map<String, String> toolingArtifactProperties) {
        String id = UUID.randomUUID().toString();
        ArtifactResources artifactResources = new ArtifactResources(artifactUrlContent);
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.DOMAIN)) {
            Domain domain = this.createDomain(id, artifactResources, toolingArtifactProperties);
            LazyValue<MetadataCache> metadataCache = this.createMetadataCache(id, domain);
            return this.newToolingArtifact(id, this.context.getDomainCache(), metadataCache, domain, this.context.getSerializer(), this.context.getServiceRegistry());
        }
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.APP)) {
            ApplicationDescriptor applicationDescriptor;
            try {
                applicationDescriptor = (ApplicationDescriptor)this.context.getApplicationDescriptorFactory().create(artifactResources.getRootArtifactFile(), Optional.empty());
            }
            catch (ToolingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ToolingException(String.format("Error while creating application from url: %s", artifactUrlContent), (Throwable)e);
            }
            ToolingArtifact domainToolingArtifact = null;
            Reference domainReference = new Reference();
            LazyValue<MetadataCache> parentMetadataCache = null;
            if (applicationDescriptor.getDomainDescriptor().isPresent()) {
                MavenClient mavenClient = this.context.getMavenClient();
                BundleDescriptor domainBundleDescriptor = (BundleDescriptor)applicationDescriptor.getDomainDescriptor().get();
                BundleDependency domainBundleDependency = mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(domainBundleDescriptor.getGroupId()).setArtifactId(domainBundleDescriptor.getArtifactId()).setVersion(domainBundleDescriptor.getVersion()).setClassifier((String)domainBundleDescriptor.getClassifier().get()).setType(domainBundleDescriptor.getType()).build());
                String domainId = UUID.randomUUID().toString();
                try {
                    domainReference.set((Object)this.createDomain(domainId, new ArtifactResources(domainBundleDependency.getBundleUri().toURL()), toolingArtifactProperties));
                }
                catch (MalformedURLException e) {
                    throw new ToolingException("Error while getting Mule domainReference artifact url", (Throwable)e);
                }
                parentMetadataCache = this.createMetadataCache(domainId, (Artifact)domainReference.get());
                domainToolingArtifact = this.newToolingArtifact(domainId, this.context.getDomainCache(), parentMetadataCache, (Domain)domainReference.get(), this.context.getSerializer(), this.context.getServiceRegistry());
            }
            try {
                ApplicationCache applicationCache = this.context.getApplicationCache();
                Application application = applicationCache.getApplication(id, () -> new DefaultApplication(id, artifactResources, applicationDescriptor, (Domain)domainReference.get(), this.context, toolingArtifactProperties, domainReference.get() != null));
                LazyValue<MetadataCache> metadataCache = this.createMetadataCache(id, application);
                return this.newToolingArtifact(id, this.context.getApplicationCache(), metadataCache, application, domainToolingArtifact, parentMetadataCache, this.context.getSerializer(), this.context.getServiceRegistry());
            }
            catch (ToolingException e) {
                this.disposeIfNeeded(domainToolingArtifact);
                throw e;
            }
            catch (Exception e) {
                this.disposeIfNeeded(domainToolingArtifact);
                throw new ToolingException(String.format("Error while creating application from url: %s", artifactUrlContent), (Throwable)e);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid artifact type, only supported '%s' and '%s'", ArtifactType.DOMAIN, ArtifactType.APP));
    }

    public void disposeIfNeeded(ToolingArtifact domainToolingArtifact) {
        if (domainToolingArtifact != null) {
            domainToolingArtifact.dispose();
        }
    }

    private Domain createDomain(String id, ArtifactResources artifactResources, Map<String, String> toolingArtifactProperties) {
        try {
            DomainDescriptor domainDescriptor = (DomainDescriptor)this.context.getDomainDescriptorFactory().create(artifactResources.getRootArtifactFile(), Optional.empty());
            DomainCache domainCache = this.context.getDomainCache();
            return domainCache.getDomain(id, () -> new DefaultDomain(id, artifactResources, domainDescriptor, (ToolingArtifactContext)this.context, toolingArtifactProperties));
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolingException(String.format("Error while creating domain from url: %s", artifactResources.getArtifactUrlContent()));
        }
    }

    public ToolingArtifact newToolingArtifact(URL artifactUrlContent, Map<String, String> toolingArtifactProperties, String parentId) {
        ApplicationDescriptor applicationDescriptor;
        Objects.requireNonNull(artifactUrlContent, "artifactUrlContent cannot be null");
        Objects.requireNonNull(toolingArtifactProperties, "toolingArtifactProperties cannot be null");
        Objects.requireNonNull(parentId, "parentId cannot be null");
        Domain domain = this.context.getDomainCache().getDomain(parentId, () -> {
            throw new ToolingArtifactNotFoundException(String.format("ToolingArtifact not found in Domain's cache for id: %s", parentId));
        });
        LazyValue<MetadataCache> parentMetadataCache = this.createMetadataCache(domain.getId(), domain);
        domain.setContext(this.context);
        ToolingArtifact domainToolingArtifact = this.newToolingArtifact(domain.getId(), this.context.getDomainCache(), parentMetadataCache, domain, this.context.getSerializer(), this.context.getServiceRegistry());
        String id = UUID.randomUUID().toString();
        ArtifactResources artifactResources = new ArtifactResources(artifactUrlContent);
        MuleApplicationModel.MuleApplicationModelBuilder applicationArtifactModelBuilder = this.context.getApplicationDescriptorFactory().createArtifactModelBuilder(artifactResources.getRootArtifactFile());
        MuleArtifactLoaderDescriptor classLoaderModelDescriptorLoader = applicationArtifactModelBuilder.getClassLoaderModelDescriptorLoader();
        HashMap<String, DefaultToolingService.DomainMavenReactorResolver> extendedAttributes = new HashMap<String, DefaultToolingService.DomainMavenReactorResolver>(classLoaderModelDescriptorLoader.getAttributes());
        extendedAttributes.put("_classLoaderModelMavenReactorResolver", new DefaultToolingService.DomainMavenReactorResolver(domain.getDescriptor().getArtifactLocation(), domain.getDescriptor().getBundleDescriptor()));
        applicationArtifactModelBuilder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(classLoaderModelDescriptorLoader.getId(), extendedAttributes));
        try {
            applicationDescriptor = this.context.getApplicationDescriptorFactory().createArtifact(artifactResources.getRootArtifactFile(), Optional.empty(), (MuleApplicationModel)applicationArtifactModelBuilder.build());
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolingException(String.format("Error while creating application from url: %s", artifactUrlContent), (Throwable)e);
        }
        this.checkDomain(domain.getDescriptor().getBundleDescriptor(), applicationDescriptor.getDomainDescriptor());
        applicationDescriptor.setDomainName(domain.getArtifactName());
        ApplicationCache applicationCache = this.context.getApplicationCache();
        Application application = applicationCache.getApplication(id, () -> new DefaultApplication(id, artifactResources, applicationDescriptor, domain, this.context, toolingArtifactProperties, true));
        LazyValue<MetadataCache> metadataCache = this.createMetadataCache(id, application);
        return this.newToolingArtifact(id, this.context.getApplicationCache(), metadataCache, application, domainToolingArtifact, parentMetadataCache, this.context.getSerializer(), this.context.getServiceRegistry());
    }

    private void checkDomain(BundleDescriptor expectedDomainBundleDescriptor, Optional<BundleDescriptor> applicationDeclaredDomainDescriptor) {
        if (!applicationDeclaredDomainDescriptor.isPresent()) {
            throw new ToolingException("Error while creating application", (Throwable)new IllegalStateException(String.format("Application doesn't declared a domain dependency on its pom.xml to: '%s'", expectedDomainBundleDescriptor)));
        }
        BundleDescriptor actualBundleDescriptor = applicationDeclaredDomainDescriptor.get();
        if (!(expectedDomainBundleDescriptor.getGroupId().equals(actualBundleDescriptor.getGroupId()) && expectedDomainBundleDescriptor.getArtifactId().equals(actualBundleDescriptor.getArtifactId()) && expectedDomainBundleDescriptor.getVersion().equals(actualBundleDescriptor.getVersion()))) {
            throw new ToolingException("Error while creating application", (Throwable)new IllegalStateException(String.format("Application declares a different domain dependency on its pom.xml expected: '%s' but was: '%s'", expectedDomainBundleDescriptor, actualBundleDescriptor)));
        }
    }

    private LazyValue<MetadataCache> createMetadataCache(String id, Artifact artifact) {
        return new LazyValue(() -> {
            NoOpMetadataCache metadataCache = NoOpMetadataCache.INSTANCE;
            if (artifact.getArtifactType().equals((Object)ArtifactType.APP)) {
                metadataCache = this.context.getMetadataCacheFactory().map(factory -> factory.createMetadataCache(id, artifact.getArtifactUrlContent(), artifact.getProperties())).orElse(NoOpMetadataCache.INSTANCE);
            }
            return metadataCache;
        });
    }

    public ToolingArtifact fetchToolingArtifact(String id) throws ToolingArtifactNotFoundException {
        Optional<Domain> domainOptional = this.context.getDomainCache().getDomain(id);
        if (domainOptional.isPresent()) {
            Domain domain = domainOptional.get();
            LazyValue<MetadataCache> domainMetadataCache = this.createMetadataCache(domain.getId(), domain);
            return this.createDomainToolingArtifact(domainOptional.get(), domainMetadataCache, this.context.getServiceRegistry());
        }
        Application application = this.context.getApplicationCache().getApplication(id, () -> {
            throw new ToolingArtifactNotFoundException(String.format("ToolingArtifact not found in cache for id: %s", id));
        });
        LazyValue<MetadataCache> applicationMetadataCache = this.createMetadataCache(id, application);
        application.setContext(this.context);
        if (application.getDomain().isPresent()) {
            Domain domain = application.getDomain().get();
            LazyValue<MetadataCache> domainMetadataCache = this.createMetadataCache(domain.getId(), domain);
            ToolingArtifact domainToolingArtifact = this.createDomainToolingArtifact(domain, domainMetadataCache, this.context.getServiceRegistry());
            return this.newToolingArtifact(id, this.context.getApplicationCache(), applicationMetadataCache, application, domainToolingArtifact, domainMetadataCache, this.context.getSerializer(), this.context.getServiceRegistry());
        }
        return this.newToolingArtifact(id, this.context.getApplicationCache(), applicationMetadataCache, application, null, null, this.context.getSerializer(), this.context.getServiceRegistry());
    }

    private ToolingArtifact createDomainToolingArtifact(Domain domain, LazyValue<MetadataCache> domainMetadataCache, ServiceRegistry serviceRegistry) {
        domain.setContext(this.context);
        return this.newToolingArtifact(domain.getId(), this.context.getDomainCache(), domainMetadataCache, domain, this.context.getSerializer(), serviceRegistry);
    }

    private ToolingArtifact newToolingArtifact(final String id, final ApplicationCache applicationCache, LazyValue<MetadataCache> metadataCache, final Application application, final ToolingArtifact parentToolingArtifact, LazyValue<MetadataCache> parentMetadataCache, Serializer serializer, ServiceRegistry serviceRegistry) {
        return new ToolingArtifactWrapper(new DefaultToolingArtifact(id, metadataCache, application, parentToolingArtifact, parentMetadataCache, serializer, serviceRegistry){

            @Override
            public void dispose() {
                applicationCache.invalidate(id);
                if (application.shouldDisposeDomain() && parentToolingArtifact != null) {
                    parentToolingArtifact.dispose();
                }
            }
        });
    }

    private ToolingArtifact newToolingArtifact(final String id, final DomainCache domainCache, LazyValue<MetadataCache> metadataCache, Domain domain, Serializer serializer, ServiceRegistry serviceRegistry) {
        return new ToolingArtifactWrapper(new DefaultToolingArtifact(id, metadataCache, domain, serializer, serviceRegistry){

            @Override
            public void dispose() {
                domainCache.invalidate(id);
            }
        });
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        Serializer serializer = this.context.getSerializer();
        switch (methodName) {
            case "messageHistoryService": {
                return this.messageHistoryService();
            }
            case "extensionModelService": {
                return this.extensionModelService();
            }
            case "artifactSerializationService": {
                return this.artifactSerializationService();
            }
            case "dslSyntaxResolverService": {
                return this.dslSyntaxResolverService();
            }
            case "iconsService": {
                return this.iconsService();
            }
            case "newToolingArtifact": {
                if (arguments.length == 3) {
                    Preconditions.checkState((arguments.length == 3 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 3 && classes[0].equals(URL.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 3 && classes[1].equals(Map.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 3 && classes[2].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    return this.newToolingArtifact((URL)serializer.deserialize(arguments[0]), (Map)serializer.deserialize(arguments[1]), (String)serializer.deserialize(arguments[2]));
                }
                if (arguments.length == 2) {
                    Preconditions.checkState((arguments.length == 2 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 2 && classes[0].equals(URL.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 2 && classes[1].equals(Map.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    return this.newToolingArtifact((URL)serializer.deserialize(arguments[0]), (Map)serializer.deserialize(arguments[1]));
                }
                Preconditions.checkState((arguments.length == 2 || arguments.length == 3 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
            }
            case "fetchToolingArtifact": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.fetchToolingArtifact((String)serializer.deserialize(arguments[0]));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

