/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.service;

import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.internal.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceRegistry.class);
    private List<Pair<ArtifactClassLoader, Service>> services;
    private LazyValue<MetadataService> apikitMetadataService;

    public DefaultServiceRegistry(List<Pair<ArtifactClassLoader, Service>> services) {
        this.services = services;
        this.startServices();
        this.apikitMetadataService = new LazyValue(() -> (MetadataService)services.stream().filter(pair -> pair.getSecond() instanceof MetadataService).map(pair -> (Service)pair.getSecond()).findFirst().orElseThrow(() -> new RuntimeException("Apikit metadata service cannot be found")));
    }

    private void startServices() {
        for (Pair<ArtifactClassLoader, Service> service : this.services) {
            try {
                LifecycleUtils.startIfNeeded((Object)service.getSecond());
            }
            catch (MuleException e) {
                LOGGER.warn(String.format("Failed to start service '%s': %s", ((Service)service.getSecond()).getName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public MetadataService getApikitMetadataService() {
        return (MetadataService)this.apikitMetadataService.get();
    }

    public void dispose() {
        this.services.stream().forEach(service -> {
            try {
                LifecycleUtils.stopIfNeeded((Object)service.getSecond());
            }
            catch (MuleException e) {
                LOGGER.warn(String.format("Failed to stop service '%s': %s", ((Service)service.getSecond()).getName(), e.getMessage()), (Throwable)e);
            }
            try {
                ((ArtifactClassLoader)service.getFirst()).dispose();
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to dispose service's class loader '%s': %s", ((Service)service.getSecond()).getName(), e.getMessage()), (Throwable)e);
            }
        });
    }
}

