/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.lang.String.format;
import static org.mule.runtime.deployment.model.api.artifact.ArtifactDescriptorConstants.MULE_LOADER_ID;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * Mimic for {@link org.mule.runtime.module.deployment.impl.internal.artifact.MavenClassLoaderModelLoader} that allows to
 * use injected instances of deployable, plugin and lib class loader model loaders.
 */
public class ToolingClassLoaderModelLoader implements ClassLoaderModelLoader {

  private List<ClassLoaderModelLoader> classLoaderModelLoaders;

  public ToolingClassLoaderModelLoader(List<ClassLoaderModelLoader> classLoaderModelLoaders) {
    this.classLoaderModelLoaders = classLoaderModelLoaders;
  }

  @Override
  public String getId() {
    return MULE_LOADER_ID;
  }

  @Override
  public ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType)
      throws InvalidDescriptorLoaderException {
    for (ClassLoaderModelLoader classLoaderModelLoader : classLoaderModelLoaders) {
      if (classLoaderModelLoader.supportsArtifactType(artifactType)) {
        return classLoaderModelLoader.load(artifactFile, attributes, artifactType);
      }
    }
    throw new IllegalStateException(format("Artifact type %s not supported", artifactType));
  }

  @Override
  public boolean supportsArtifactType(ArtifactType artifactType) {
    return classLoaderModelLoaders.stream()
        .filter(classLoaderModelLoader -> classLoaderModelLoader.supportsArtifactType(artifactType)).findFirst().isPresent();
  }
}
