/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

/**
 * Deploys and disposes applications on Mule Runtime.
 *
 * @since 4.0
 */
public interface ArtifactDeployer {

  /**
   * Deploys the artifact on Mule Runtime and returns the id.
   *
   * @param domainId {@link String} representing the domain identifier.
   * @return {@link String} id generated for the deployed artifact.
   */
  //TODO refactor this!
  String deploy(String domainId);

  /**
   * Disposes the artifact on Mule Runtime for the given id.
   *
   * @param {@link String} id of the deployed artifact to be disposed.
   */
  void dispose(String id);

}
