/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.internal.application.Domain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainCache
implements Disposable {
    private static final String TOOLING_CLIENT_DOMAIN_CACHE_EXPIRE_AFTER_ACCESS = "tooling.client.DomainCache.expireAfterAccess";
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainCache.class);
    private Cache<String, Domain> domainsById = this.createCache();

    private Cache<String, Domain> createCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        this.cacheExpireAfterAccess().ifPresent(value -> builder.expireAfterAccess(value.longValue(), TimeUnit.SECONDS));
        builder.removalListener(notification -> ((Domain)notification.getValue()).dispose());
        return builder.build();
    }

    private Optional<Long> cacheExpireAfterAccess() {
        if (System.getProperty(TOOLING_CLIENT_DOMAIN_CACHE_EXPIRE_AFTER_ACCESS) == null) {
            return Optional.empty();
        }
        Long cacheSize = Long.valueOf(System.getProperty(TOOLING_CLIENT_DOMAIN_CACHE_EXPIRE_AFTER_ACCESS));
        Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, cacheExpireAfterAccess cannot be less that zero", cacheSize, TOOLING_CLIENT_DOMAIN_CACHE_EXPIRE_AFTER_ACCESS));
        return Optional.of(cacheSize);
    }

    public DomainCache() {
        LOGGER.info("Initialising Domain cache");
    }

    public Optional<Domain> getDomain(String id) {
        return Optional.ofNullable(this.domainsById.getIfPresent((Object)id));
    }

    public Domain getDomain(String id, Callable<Domain> callable) {
        try {
            return (Domain)this.domainsById.get((Object)id, callable);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void invalidate(String id) {
        this.domainsById.invalidate((Object)id);
    }

    public void dispose() {
        LOGGER.info("Disposing Domain cache");
        this.domainsById.invalidateAll();
    }
}

