/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.datasense.api.metadataprovider.ToolingHelper;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.el.DataFormat;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tooling.client.api.dataweave.DataWeaveModuleOption;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.dataweave.validation.DataWeaveValidationRequest;
import org.mule.tooling.client.api.el.Location;
import org.mule.tooling.client.api.el.Position;
import org.mule.tooling.client.api.el.Severity;
import org.mule.tooling.client.api.el.ValidationMessage;
import org.mule.tooling.client.api.el.ValidationResult;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunner;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;

public class DefaultDataWeaveService
implements DataWeaveService,
Command {
    private final LazyValue<ClassLoader> executionClassLaoder;
    private ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private ModulesAnalyzer modulesAnalyzer;
    private DataWeaveRunner runner;
    private Serializer serializer;

    public DefaultDataWeaveService(LazyValue<ClassLoader> executionClassLoader, DataWeaveRunner runner, ExpressionLanguageMetadataService expressionLanguageMetadataService, ModulesAnalyzer modulesAnalyzer, Serializer serializer) {
        this.executionClassLaoder = executionClassLoader;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.runner = runner;
        this.modulesAnalyzer = modulesAnalyzer;
        this.serializer = serializer;
    }

    public DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters) {
        EventModel event = parameters.getEvent();
        if (event != null && this.anyInputIsJavaBased(event)) {
            throw new IllegalArgumentException("Java input not supported, serialize to DW script");
        }
        return this.runner.execute(parameters);
    }

    public ValidationResult validate(DataWeaveValidationRequest request) {
        return (ValidationResult)ClassUtils.withContextClassLoader((ClassLoader)((ClassLoader)this.executionClassLaoder.get()), () -> {
            final ArrayList validationMessages = new ArrayList();
            this.expressionLanguageMetadataService.getOutputType(ToolingHelper.resolveTypeBindings((MetadataType)request.getEventType(), (Map)request.getGlobalBindings(), (Map)request.getFunctionBindings()), request.getScript(), new ExpressionLanguageMetadataService.MessageCallback(){

                public void warning(String message, ExpressionLanguageMetadataService.MessageLocation location) {
                    validationMessages.add(new ValidationMessage(Severity.WARNING, message, DefaultDataWeaveService.this.toLocation(location)));
                }

                public void error(String message, ExpressionLanguageMetadataService.MessageLocation location) {
                    validationMessages.add(new ValidationMessage(Severity.ERROR, message, DefaultDataWeaveService.this.toLocation(location)));
                }
            });
            return new ValidationResult(validationMessages);
        });
    }

    private Location toLocation(ExpressionLanguageMetadataService.MessageLocation location) {
        ExpressionLanguageMetadataService.MessagePosition startPosition = location.getStartPosition();
        ExpressionLanguageMetadataService.MessagePosition endPosition = location.getEndPosition();
        return new Location(new Position(startPosition.getLine(), startPosition.getColumn(), startPosition.getOffset()), new Position(endPosition.getLine(), endPosition.getColumn(), endPosition.getOffset()));
    }

    private boolean anyInputIsJavaBased(EventModel event) {
        MessageModel message = event.getMessage();
        if (this.isJavaBased(message.getPayload()) || this.isJavaBased(message.getAttributes())) {
            return true;
        }
        Map variables = event.getVariables();
        return variables != null && variables.values().stream().anyMatch(this::isJavaBased);
    }

    private boolean isJavaBased(TypedValueModel model) {
        return model != null && MediaType.parse((String)model.getDataType().getMediaType()).equals((Object)MediaType.APPLICATION_JAVA);
    }

    public List<DataWeaveModuleOption> getReaderOptions(String contentType) {
        return this.modulesAnalyzer.getOptions(contentType, DataFormat::getReaderOptions);
    }

    public List<DataWeaveModuleOption> getWriterOptions(String contentType) {
        return this.modulesAnalyzer.getOptions(contentType, DataFormat::getWriterOptions);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "execute": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(DataWeavePreviewRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.execute((DataWeavePreviewRequest)this.serializer.deserialize(arguments[0])));
            }
            case "validate": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(DataWeaveValidationRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.validate((DataWeaveValidationRequest)this.serializer.deserialize(arguments[0])));
            }
            case "getReaderOptions": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize(this.getReaderOptions((String)this.serializer.deserialize(arguments[0])));
            }
            case "getWriterOptions": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize(this.getWriterOptions((String)this.serializer.deserialize(arguments[0])));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

