/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.cache;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.IdentifiableElementDeclaration;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelperUtils;
import org.mule.tooling.client.internal.metadata.ComponentModelMediator;
import org.mule.tooling.client.internal.metadata.ToolingCacheIdGenerator;
import org.mule.tooling.client.internal.session.ExtensionModelProvider;
import org.mule.tooling.client.internal.session.cache.DeclarationMetadataCache;
import org.mule.tooling.client.internal.utils.FunctionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeclarationMetadataCache
implements DeclarationMetadataCache {
    private final Map<String, MetadataType> typesStorage;
    private final Map<String, MetadataResult<MetadataKeysContainer>> keysStorage;
    private final ToolingCacheIdGenerator<ElementDeclaration> cacheIdGenerator;
    private final ExtensionModelProvider extensionModelProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDeclarationMetadataCache.class);

    public DefaultDeclarationMetadataCache(ToolingCacheIdGenerator<ElementDeclaration> cacheIdGenerator, Map<String, MetadataType> typesStorage, Map<String, MetadataResult<MetadataKeysContainer>> keysStorage, ExtensionModelProvider extensionModelProvider) {
        this.cacheIdGenerator = cacheIdGenerator;
        this.typesStorage = typesStorage;
        this.keysStorage = keysStorage;
        this.extensionModelProvider = extensionModelProvider;
    }

    @Override
    public MetadataResult<ComponentMetadataTypesDescriptor> getComponentMetadata(ComponentElementDeclaration<?> componentElementDeclaration, Callable<MetadataResult<ComponentMetadataTypesDescriptor>> resolver, boolean forceResolution) {
        ComponentModel staticComponentModel = (ComponentModel)this.getModel((ElementDeclaration)componentElementDeclaration);
        Optional<Object> enrichedComponentModel = Optional.empty();
        if (!forceResolution) {
            ComponentModelMediator componentModelMediator = new ComponentModelMediator(this.typesStorage, this.cacheIdGenerator, componentElementDeclaration, componentElementDeclaration.getName(), staticComponentModel);
            enrichedComponentModel = componentModelMediator.enrichComponentModel();
        }
        if (enrichedComponentModel.isPresent()) {
            return MetadataResult.success((Object)this.descriptorFromModel((ComponentModel)enrichedComponentModel.get()));
        }
        MetadataResult result = FunctionalUtils.executeHandling(resolver, e -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()}));
        if (result.isSuccess()) {
            this.populateTypesCache((ElementDeclaration)componentElementDeclaration, (ComponentMetadataTypesDescriptor)result.get());
        }
        return result;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentElementDeclaration elementDeclaration, Callable<MetadataResult<MetadataKeysContainer>> resolver, boolean forceResolution) {
        return this.doGetMetadataKeys(elementDeclaration, resolver, forceResolution);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeysPartialFetch(ParameterizedModel parameterizedModel, final ComponentElementDeclaration elementDeclaration, Callable<MetadataResult<MetadataKeysContainer>> resolver, boolean forceResolution) {
        MetadataResult<MetadataKeysContainer> metadataKeysContainerMetadataResult = this.doGetMetadataKeys(elementDeclaration, resolver, forceResolution);
        if (forceResolution && !metadataKeysContainerMetadataResult.isSuccess() && metadataKeysContainerMetadataResult.getFailures().stream().filter(f -> f.getFailureCode().equals((Object)FailureCode.INVALID_METADATA_KEY)).findAny().isPresent()) {
            if (!(parameterizedModel instanceof EnrichableModel)) {
                LOGGER.warn(String.format("ParameterizeModel '{}' from '{}:{}' should be an EnrichableModel", parameterizedModel.getName(), elementDeclaration.getDeclaringExtension(), elementDeclaration.getName()));
                return metadataKeysContainerMetadataResult;
            }
            ((EnrichableModel)parameterizedModel).getModelProperty(MetadataKeyIdModelProperty.class).ifPresent(metadataKeyIdModelProperty -> {
                List metadataKeyPartParameterModels = parameterizedModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted(Comparator.comparingInt(p -> ((MetadataKeyPartModelProperty)((EnrichableModel)p).getModelProperty(MetadataKeyPartModelProperty.class).get()).getOrder()).reversed()).collect(Collectors.toList());
                Reference parameterElementDeclarationsReference = new Reference();
                metadataKeyIdModelProperty.getType().accept(new MetadataTypeVisitor((MetadataKeyIdModelProperty)metadataKeyIdModelProperty, parameterizedModel, metadataKeyPartParameterModels){
                    final /* synthetic */ MetadataKeyIdModelProperty val$metadataKeyIdModelProperty;
                    final /* synthetic */ ParameterizedModel val$parameterizedModel;
                    final /* synthetic */ List val$metadataKeyPartParameterModels;
                    {
                        this.val$metadataKeyIdModelProperty = metadataKeyIdModelProperty;
                        this.val$parameterizedModel = parameterizedModel;
                        this.val$metadataKeyPartParameterModels = list;
                    }

                    public void visitObject(ObjectType objectType) {
                        Optional elementDeclarationParameterGroupOptional = elementDeclaration.getParameterGroup(this.val$metadataKeyIdModelProperty.getParameterName());
                        if (!elementDeclarationParameterGroupOptional.isPresent()) {
                            LOGGER.warn("Could not find metadataKeyIdModelProperty.name='{}' as parameterGroup on parameterizableModel '{}' for element '{}:{}'", new Object[]{this.val$metadataKeyIdModelProperty.getName(), this.val$parameterizedModel.getName(), elementDeclaration.getDeclaringExtension(), elementDeclaration.getName()});
                        }
                        elementDeclarationParameterGroupOptional.ifPresent(elementDeclarationParameterGroup -> {
                            List parameterElementDeclarations = elementDeclarationParameterGroup.getParameters();
                            this.val$metadataKeyPartParameterModels.stream().forEach(keyParameterModel -> {
                                parameterElementDeclarations.removeIf(parameterElementDeclaration -> parameterElementDeclaration.getName().equals(keyParameterModel.getName()));
                                DefaultDeclarationMetadataCache.this.cacheIdGenerator.getIdForMetadataKeys(elementDeclaration).map(id -> DefaultDeclarationMetadataCache.this.keysStorage.keySet().remove(id)).orElseGet(() -> {
                                    LOGGER.warn("Couldn't create a metadata cache id for component: %s", (Object)elementDeclaration.getName());
                                    return null;
                                });
                            });
                        });
                    }

                    protected void defaultVisit(MetadataType metadataType) {
                        LOGGER.warn("Could not invalidate upper level of combinations for partial type key resolver from cache as metadataKeyIdModelProperty.name='{}' is not an ObjectType, instead: '{}' for element '{}:{}'", new Object[]{this.val$metadataKeyIdModelProperty.getName(), metadataType.getClass().getName(), elementDeclaration.getDeclaringExtension(), elementDeclaration.getName()});
                    }
                });
            });
        }
        return metadataKeysContainerMetadataResult;
    }

    private MetadataResult<MetadataKeysContainer> doGetMetadataKeys(ComponentElementDeclaration elementDeclaration, Callable<MetadataResult<MetadataKeysContainer>> resolver, boolean forceResolution) {
        return this.cacheIdGenerator.getIdForMetadataKeys((ElementDeclaration)elementDeclaration).map(id -> {
            MetadataResult<MetadataKeysContainer> result;
            if (forceResolution) {
                this.keysStorage.keySet().remove(id);
            }
            if (this.keysStorage.containsKey(id)) {
                try {
                    result = this.keysStorage.get(id);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Exception result2) {
                    // empty catch block
                }
            }
            if ((result = FunctionalUtils.executeHandling(resolver, e -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onKeys()}))).isSuccess()) {
                this.keysStorage.put((String)id, result);
            }
            return result;
        }).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't create a metadata cache id for component: %s", elementDeclaration.getName())));
    }

    private <T extends ParameterizedModel & EnrichableModel> T getModel(ElementDeclaration elementDeclaration) throws IllegalArgumentException {
        return (T)this.extensionModelProvider.get(elementDeclaration.getDeclaringExtension()).map(em -> (ParameterizedModel)ArtifactHelperUtils.findModel((ExtensionModel)em, (IdentifiableElementDeclaration)elementDeclaration).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find ComponentModel for:  %s in extension with name: %s", elementDeclaration.getName(), em.getName())))).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find ExtensionModel for extension with name: %s. Available: %s", elementDeclaration.getDeclaringExtension(), this.extensionModelProvider.getAllNames())));
    }

    private void populateTypesCache(ElementDeclaration elementDeclaration, ComponentMetadataTypesDescriptor types) {
        types.getInputMetadata().forEach((parameterName, parameterType) -> this.cacheIdGenerator.getIdForComponentInputMetadata(elementDeclaration, (String)parameterName).ifPresent(id -> this.typesStorage.put((String)id, (MetadataType)parameterType)));
        types.getOutputAttributesMetadata().ifPresent(outputAttributes -> this.cacheIdGenerator.getIdForComponentAttributesMetadata(elementDeclaration).ifPresent(id -> this.typesStorage.put((String)id, (MetadataType)outputAttributes)));
        types.getOutputMetadata().ifPresent(outputMetadata -> this.cacheIdGenerator.getIdForComponentOutputMetadata(elementDeclaration).ifPresent(id -> this.typesStorage.put((String)id, (MetadataType)outputMetadata)));
    }

    private <T extends ComponentModel> ComponentMetadataTypesDescriptor descriptorFromModel(T model) {
        ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder();
        if (model instanceof HasOutputModel) {
            HasOutputModel outputModel = (HasOutputModel)model;
            builder.withOutputMetadataDescriptor(OutputMetadataDescriptor.builder().withReturnType(TypeMetadataDescriptor.builder().withType(outputModel.getOutput().getType()).dynamic(outputModel.getOutput().hasDynamicType()).build()).withAttributesType(TypeMetadataDescriptor.builder().withType(outputModel.getOutputAttributes().getType()).dynamic(outputModel.getOutputAttributes().hasDynamicType()).build()).build());
        }
        InputMetadataDescriptor.InputMetadataDescriptorBuilder inputBuilder = InputMetadataDescriptor.builder();
        model.getAllParameterModels().forEach(pm -> inputBuilder.withParameter(pm.getName(), ParameterMetadataDescriptor.builder((String)pm.getName()).withType(pm.getType()).dynamic(pm.hasDynamicType()).build()));
        return builder.withInputMetadataDescriptor(inputBuilder.build()).build();
    }
}

