/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.validation;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.tooling.client.internal.session.ConfigurationDeclarationProvider;
import org.mule.tooling.client.internal.session.validation.ComponentValidationContext;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.Validators;

public class ConnectionAndConfigurationValidator
implements Validators.ComponentValidator {
    private final ParameterizedElementDeclaration elementDeclaration;
    private final Supplier<Boolean> requiresConnection;
    private final Supplier<Boolean> requiresConfiguration;
    private final ConfigurationDeclarationProvider configurationDeclarationProvider;
    private final Supplier<String> errorLocationPrefix;

    public ConnectionAndConfigurationValidator(ParameterizedElementDeclaration elementDeclaration, ConfigurationDeclarationProvider configurationDeclarationProvider, Supplier<Boolean> requiresConnection, Supplier<Boolean> requiresConfiguration, Supplier<String> errorLocationPrefix) {
        this.elementDeclaration = elementDeclaration;
        this.configurationDeclarationProvider = configurationDeclarationProvider;
        this.requiresConnection = requiresConnection;
        this.requiresConfiguration = requiresConfiguration;
        this.errorLocationPrefix = errorLocationPrefix;
    }

    @Override
    public void validate(ComponentValidationContext<?> context) throws SessionCallValidationException {
        String requiresString;
        boolean requiresConfig = this.requiresConfiguration.get();
        boolean requiresConn = this.requiresConnection.get();
        String string = requiresConfig ? (requiresConn ? "configuration and connection" : "configuration") : (requiresString = "connection");
        if (this.elementDeclaration instanceof ComponentElementDeclaration && (requiresConfig || requiresConn)) {
            Optional connectionElementDeclaration;
            String configRef = ((ComponentElementDeclaration)this.elementDeclaration).getConfigRef();
            if (StringUtils.isEmpty((CharSequence)configRef)) {
                throw new SessionCallValidationException(String.format("%s requires %s for resolution but there is no configuration referenced", this.errorLocationPrefix.get(), requiresString), "There is no configuration referenced", "MISSING_REQUIRED_PARAMETERS");
            }
            Optional<ConfigurationElementDeclaration> configurationElementDeclaration = this.configurationDeclarationProvider.getConfigDeclaration(configRef);
            if (!configurationElementDeclaration.isPresent()) {
                throw new SessionCallValidationException(String.format("%s requires %s for resolution but the configuration referenced with ref-name: '%s' is not present", this.errorLocationPrefix.get(), requiresString, configRef), "Configuration referenced is not present", FailureCode.COMPONENT_NOT_FOUND.getName());
            }
            if (requiresConn && !(connectionElementDeclaration = configurationElementDeclaration.get().getConnection()).isPresent()) {
                throw new SessionCallValidationException(String.format("%s requires connection for resolution but the configuration referenced with ref-name: '%s' does not have a connection", this.errorLocationPrefix.get(), configRef), "Configuration referenced does not have connection", FailureCode.COMPONENT_NOT_FOUND.getName());
            }
        }
    }
}

