/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import org.mule.tooling.client.internal.utils.JarUtils;

public class SchemaGetterUtils {
    public static final String KEYS_SEPARATOR = "=";
    private static String SPRING_MODULE_SCHEMA_KEY = "http://www.mulesoft.org/schema/mule/spring/current/mule-spring.xsd";
    public static String SPRING_MODULE_PROPERTIES_LOCATION = "META-INF/mule.schemas";
    private JarUtils jarUtils;

    public SchemaGetterUtils(JarUtils jarUtils) {
        this.jarUtils = jarUtils;
    }

    public Optional<File> getSchemaFile(File pluginJar) throws IOException {
        Properties schemaPropertiesFile;
        Optional<Object> schemaPathLocationOptional;
        File propertiesFile;
        Optional<File> fileOptional = Optional.empty();
        Optional<File> decompressedFileOptional = this.jarUtils.decompressJarFile(pluginJar);
        if (decompressedFileOptional.isPresent() && (propertiesFile = new File(decompressedFileOptional.get().getAbsoluteFile() + File.separator + SPRING_MODULE_PROPERTIES_LOCATION)).exists() && (schemaPathLocationOptional = Optional.ofNullable((schemaPropertiesFile = this.getPropertiesFromFile(propertiesFile.toPath())).get(SPRING_MODULE_SCHEMA_KEY))).isPresent()) {
            File schemaFile = new File(decompressedFileOptional.get().getAbsoluteFile() + File.separator + schemaPathLocationOptional.get());
            fileOptional = schemaFile.exists() ? Optional.of(schemaFile) : Optional.empty();
        }
        return fileOptional;
    }

    private Properties getPropertiesFromFile(Path filePath) throws IOException {
        Properties properties = new Properties();
        properties.load(Files.newInputStream(filePath, new OpenOption[0]));
        return properties;
    }
}

