/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import static java.lang.String.format;
import static org.mule.runtime.api.util.Preconditions.checkState;
import static org.mule.tooling.client.internal.Command.methodNotFound;
import static org.mule.tooling.client.internal.ComponentLocationFactory.toComponentLocationDTO;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tooling.client.api.component.location.ArtifactComponentLocations;
import org.mule.tooling.client.api.component.location.ComponentLocation;
import org.mule.tooling.client.api.component.location.ComponentLocationService;
import org.mule.tooling.client.internal.serialization.Serializer;

import java.util.HashSet;
import java.util.Set;

public class DefaultComponentLocationService implements ComponentLocationService, Command {

  private Serializer serializer;
  private LazyValue<ArtifactComponentLocations> artifactComponentLocations;


  public DefaultComponentLocationService(LazyValue<ApplicationModel> applicationModelLazyValue, Serializer serializer) {
    this.serializer = serializer;
    this.artifactComponentLocations = new LazyValue<>(() -> {
      Set<ComponentLocation> componentLocations = new HashSet<>();
      applicationModelLazyValue.get().getRootComponentModel()
          .executedOnEveryInnerComponent(componentModel -> {
            if (componentModel.getComponentLocation() != null) {
              componentLocations.add(convertComponentLocation(componentModel.getComponentLocation()));
            }
          });
      return new ArtifactComponentLocations(componentLocations);
    });
  }

  @Override
  public ArtifactComponentLocations getComponentLocations() {
    return artifactComponentLocations.get();
  }

  private ComponentLocation convertComponentLocation(DefaultComponentLocation componentLocation) {
    return toComponentLocationDTO(componentLocation);
  }

  @Override
  public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
    switch (methodName) {
      case "getComponentLocations": {
        checkState(arguments.length == 0,
                   format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
        return serializer.serialize(getComponentLocations());
      }
    }
    throw methodNotFound(this.getClass(), methodName);
  }
}
