/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ToolingException;

import java.io.Serializable;
import java.util.concurrent.Callable;

/**
 * No operation metadata cache.
 *
 * @since 4.0
 */
public class NoOpMetadataCache implements MetadataCache {

  public static final NoOpMetadataCache INSTANCE = new NoOpMetadataCache();

  private NoOpMetadataCache() {}

  @Override
  public Serializable getOperationMetadata(MetadataCacheKeyInfo metadataCacheKeyInfo,
                                           Callable<MetadataResult> resolver) {
    return executeResolver(resolver);
  }

  @Override
  public Serializable getSourceMetadata(MetadataCacheKeyInfo metadataCacheKeyInfo,
                                        Callable<MetadataResult> resolver) {
    return executeResolver(resolver);
  }

  @Override
  public Serializable getMetadataKeys(MetadataCacheKeyInfo metadataCacheKeyInfo,
                                      Callable<MetadataResult> resolver) {
    return executeResolver(resolver);
  }

  private Serializable executeResolver(Callable<MetadataResult> callable) {
    try {
      return callable.call().getResult();
    } catch (Exception e) {
      throw new ToolingException("Error while resolving metadata", e);
    }
  }

}
