/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.parsers.SAXParserFactory;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.ResourceLocator;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.internal.ModuleDelegatingEntityResolver;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.xml.XmlNamespaceInfoProviderSupplier;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.core.internal.config.RuntimeComponentBuildingDefinitionsUtil;
import org.mule.runtime.core.internal.util.DefaultResourceLocator;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationProcessor;
import org.mule.runtime.dsl.api.xml.parser.XmlParsingConfiguration;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.ApplicationModelFactory;
import org.xml.sax.EntityResolver;

public class DefaultApplicationModelFactory
implements ApplicationModelFactory {
    @Override
    public Optional<ApplicationModel> createApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor, Set<ExtensionModel> extensionModels, ClassLoader applicationClassLoader, ConfigurationProperties parentConfigurationProperties, Map<String, String> deploymentProperties) {
        try {
            return Optional.of(this.loadApplicationModel(deployableArtifactDescriptor, extensionModels, applicationClassLoader, parentConfigurationProperties, deploymentProperties));
        }
        catch (Exception e) {
            throw new ToolingException("Error while creating application model", (Throwable)e);
        }
    }

    private ApplicationModel loadApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor, Set<ExtensionModel> extensionModels, ClassLoader applicationClassLoader, ConfigurationProperties parentConfigurationProperties, Map<String, String> deploymentProperties) {
        ToolingArtifactXmlParsingConfiguration parsingConfiguration = new ToolingArtifactXmlParsingConfiguration(deployableArtifactDescriptor, extensionModels, applicationClassLoader);
        ArtifactConfig artifactConfig = (ArtifactConfig)ClassUtils.withContextClassLoader((ClassLoader)applicationClassLoader, () -> new ArtifactConfig.Builder().setApplicationName(deployableArtifactDescriptor.getName()).addConfigFiles((Collection)XmlConfigurationProcessor.processXmlConfiguration((XmlParsingConfiguration)parsingConfiguration)).build());
        return (ApplicationModel)ClassUtils.withContextClassLoader((ClassLoader)applicationClassLoader, () -> new ApplicationModel(artifactConfig, null, extensionModels, deploymentProperties, Optional.of(parentConfigurationProperties), Optional.of(DefaultApplicationModelFactory.createComponentBuildingDefinitionRegistry()), false, (ResourceProvider)new ClassLoaderResourceProvider(applicationClassLoader)));
    }

    private static ComponentBuildingDefinitionRegistry createComponentBuildingDefinitionRegistry() {
        ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
        RuntimeComponentBuildingDefinitionsUtil.getRuntimeComponentBuildingDefinitionProvider().getComponentBuildingDefinitions().forEach(arg_0 -> ((ComponentBuildingDefinitionRegistry)componentBuildingDefinitionRegistry).register(arg_0));
        return componentBuildingDefinitionRegistry;
    }

    private class ToolingArtifactXmlParsingConfiguration
    implements XmlParsingConfiguration {
        private Set<ExtensionModel> extensionModels;
        private ConfigResource[] configResources;

        public ToolingArtifactXmlParsingConfiguration(DeployableArtifactDescriptor artifactDescriptor, Set<ExtensionModel> extensionModels, ClassLoader artifactClassLoader) {
            this.extensionModels = extensionModels;
            this.configResources = (ConfigResource[])artifactDescriptor.getConfigResources().stream().map(configFile -> {
                URL url = artifactClassLoader.getResource((String)configFile);
                if (url == null) {
                    throw new ToolingException(String.format("Configuration file '%s' cannot be found", configFile));
                }
                try {
                    return new ConfigResource(configFile, url.openStream());
                }
                catch (IOException e) {
                    throw new ToolingException(String.format("Error while reading configuration file '%s'", configFile), (Throwable)e);
                }
            }).toArray(ConfigResource[]::new);
        }

        public ParsingPropertyResolver getParsingPropertyResolver() {
            return propertyKey -> propertyKey;
        }

        public ConfigResource[] getArtifactConfigResources() {
            return this.configResources;
        }

        public ResourceLocator getResourceLocator() {
            return new DefaultResourceLocator();
        }

        public Supplier<SAXParserFactory> getSaxParserFactory() {
            return () -> XMLSecureFactories.createDefault().getSAXParserFactory();
        }

        public XmlConfigurationDocumentLoader getXmlConfigurationDocumentLoader() {
            return XmlConfigurationDocumentLoader.noValidationDocumentLoader();
        }

        public EntityResolver getEntityResolver() {
            return new ModuleDelegatingEntityResolver(this.extensionModels);
        }

        public List<XmlNamespaceInfoProvider> getXmlNamespaceInfoProvider() {
            return XmlNamespaceInfoProviderSupplier.createFromExtensionModels(this.extensionModels, Optional.empty());
        }
    }
}

