/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.ArtifactDeployer;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.application.RemoteArtifactContextFactory;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifact<T extends DeployableArtifactDescriptor>
implements Artifact {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArtifact.class);
    private String id;
    private Map<String, String> properties;
    protected ToolingArtifactContext context;
    private LazyValue<List<ExtensionModel>> extensionModels;
    private LazyValue<ToolingArtifactClassLoader> artifactClassLoader;
    private LazyValue<ToolingApplicationModel> applicationModel;
    protected ArtifactResources artifactResources;
    protected T artifactDescriptor;
    protected String remoteArtifactId;
    protected LazyValue<RuntimeToolingService> runtimeToolingService;
    protected ArtifactDeployer artifactDeployer;
    private AtomicBoolean disposed = new AtomicBoolean(false);
    protected NoFailureConfigurationProperties noFailureConfigurationProperties = new NoFailureConfigurationProperties();

    AbstractArtifact(String id, ArtifactResources artifactResources, T artifactDescriptor, ToolingArtifactContext context, Map<String, String> properties) {
        Objects.requireNonNull(id, "id cannot be null");
        Objects.requireNonNull(artifactResources, "artifactResources cannot be null");
        Objects.requireNonNull(artifactDescriptor, "artifactBundleDescriptor cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        Objects.requireNonNull(properties, "properties cannot be null");
        this.id = id;
        this.artifactResources = artifactResources;
        this.artifactDescriptor = artifactDescriptor;
        this.context = context;
        this.properties = properties;
        this.applicationModel = this.newToolingApplicationModelLazyValue();
        this.artifactClassLoader = this.newToolingArtifactClassLoaderLazyValue();
        this.extensionModels = this.newExtensionModelsLazyValue();
        this.runtimeToolingService = new LazyValue(() -> context.getRuntimeToolingService());
        this.artifactDeployer = RemoteArtifactContextFactory.createRemoteArtifactContext(artifactResources, properties, this.runtimeToolingService);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.artifactResources.getArtifactType();
    }

    @Override
    public List<ExtensionModel> getExtensionModels() {
        this.checkState();
        return (List)this.extensionModels.get();
    }

    @Override
    public String getArtifactName() {
        this.checkState();
        return this.getArtifactClassLoader().getArtifactId();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public URL getArtifactUrlContent() {
        this.checkState();
        return this.artifactResources.getArtifactUrlContent();
    }

    @Override
    public ToolingArtifactClassLoader getArtifactClassLoader() {
        this.checkState();
        return (ToolingArtifactClassLoader)this.artifactClassLoader.get();
    }

    @Override
    public synchronized void setContext(ToolingArtifactContext context) {
        this.checkState();
        if (this.context != null && this.context.getAgentConfiguration().isPresent() && context.getAgentConfiguration().isPresent() && !this.context.getAgentConfiguration().get().getToolingApiUrl().equals(context.getAgentConfiguration().get().getToolingApiUrl())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Application context has changed, trying to dispose (if present) the remote application");
            }
            this.disposeRemoteArtifactContext();
        }
        this.context = context;
    }

    public synchronized void dispose() {
        this.checkState();
        if (!this.disposed.getAndSet(true)) {
            this.disposeClassLoader();
            this.disposeResources();
            this.disposeRemoteArtifactContext();
        }
    }

    protected void disposeRemoteArtifactContext() {
        if (this.remoteArtifactId != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing Mule Runtime remote artifact for artifactId: {}", (Object)this.remoteArtifactId);
            }
            try {
                this.artifactDeployer.dispose(this.remoteArtifactId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.remoteArtifactId = null;
        }
    }

    private void disposeResources() {
        if (this.artifactResources != null) {
            this.artifactResources.dispose();
        }
        this.applicationModel = null;
        this.extensionModels = null;
    }

    private void disposeClassLoader() {
        if (this.artifactClassLoader != null && this.artifactClassLoader.isComputed()) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Disposing artifact class loader");
                }
                ((ToolingArtifactClassLoader)this.artifactClassLoader.get()).dispose();
            }
            finally {
                this.artifactClassLoader = null;
            }
        }
    }

    @Override
    public ToolingApplicationModel getApplicationModel() {
        this.checkState();
        return (ToolingApplicationModel)this.applicationModel.get();
    }

    @Override
    public MuleVersion getMinMuleVersion() {
        this.checkState();
        MuleVersion effectiveMinMuleVersion = this.artifactDescriptor.getMinMuleVersion();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : this.getEffectivePlugins()) {
            MuleVersion candidate = artifactPluginDescriptor.getMinMuleVersion();
            if (!candidate.newerThan(effectiveMinMuleVersion)) continue;
            effectiveMinMuleVersion = candidate;
        }
        return effectiveMinMuleVersion;
    }

    protected List<ArtifactPluginDescriptor> getEffectivePlugins() {
        return ImmutableList.copyOf((Collection)this.artifactDescriptor.getPlugins());
    }

    protected abstract LazyValue<ToolingArtifactClassLoader> newToolingArtifactClassLoaderLazyValue();

    protected abstract LazyValue<ToolingApplicationModel> newToolingApplicationModelLazyValue();

    private LazyValue<List<ExtensionModel>> newExtensionModelsLazyValue() {
        return new LazyValue(() -> {
            List extensionModels = this.getArtifactPluginClassLoaders().stream().map(artifactPluginClassLoader -> this.createBundleDependency(artifactPluginClassLoader.getArtifactDescriptor())).map(bundleDependency -> this.context.getMuleRuntimeExtensionModelProvider().getExtensionModel((BundleDependency)bundleDependency).orElse(null)).filter(extensionModel -> extensionModel != null).collect(Collectors.toList());
            extensionModels.addAll(this.context.getMuleRuntimeExtensionModelProvider().getRuntimeExtensionModels());
            return extensionModels;
        });
    }

    private BundleDependency createBundleDependency(ArtifactDescriptor artifactDescriptor) {
        BundleDescriptor bundleDescriptor = artifactDescriptor.getBundleDescriptor();
        try {
            BundleDescriptor.Builder bundleDescriptorBuilder = new BundleDescriptor.Builder();
            bundleDescriptorBuilder.setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId());
            if (bundleDescriptor.getBaseVersion() != null) {
                bundleDescriptorBuilder.setBaseVersion(bundleDescriptor.getBaseVersion());
            }
            bundleDescriptorBuilder.setVersion(bundleDescriptor.getVersion()).setType(bundleDescriptor.getType()).setClassifier((String)bundleDescriptor.getClassifier().orElse(null));
            return new BundleDependency.Builder().setBundleUri(artifactDescriptor.getClassLoaderModel().getUrls()[0].toURI()).sedBundleDescriptor(bundleDescriptorBuilder.build()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<ArtifactClassLoader> getArtifactPluginClassLoaders() {
        return ((ToolingArtifactClassLoader)this.artifactClassLoader.get()).getArtifactPluginClassLoaders();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{artifactName=" + this.getArtifactName() + ", artifactResources=" + this.artifactResources + "}";
    }

    protected void checkState() {
        Preconditions.checkState((!this.disposed.get() ? 1 : 0) != 0, (Object)"Application already disposed, cannot be used anymore");
    }

    private class NoFailureConfigurationProperties
    implements ConfigurationProperties {
        private NoFailureConfigurationProperties() {
        }

        public <T> Optional<T> resolveProperty(String key) {
            return Optional.of("");
        }

        public Optional<Boolean> resolveBooleanProperty(String key) {
            return Optional.of(false);
        }

        public Optional<String> resolveStringProperty(String key) {
            return Optional.of("");
        }
    }
}

