/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.ArtifactCopyNativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.tooling.ToolingApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;

public class ApplicationClassLoaderFactory {
    private ArtifactClassLoader containerArtifactClassLoader;
    private RegionPluginClassLoadersFactory regionPluginClassLoadersFactory;
    private PluginDependenciesResolver pluginDependenciesResolver;

    public ApplicationClassLoaderFactory(ArtifactClassLoader containerArtifactClassLoader, RegionPluginClassLoadersFactory regionPluginClassLoadersFactory, PluginDependenciesResolver pluginDependenciesResolver) {
        Objects.requireNonNull(containerArtifactClassLoader, "containerArtifactClassLoader cannot be null");
        Objects.requireNonNull(regionPluginClassLoadersFactory, "regionPluginClassLoadersFactory cannot be null");
        Objects.requireNonNull(pluginDependenciesResolver, "pluginDependenciesResolver cannot be null");
        this.containerArtifactClassLoader = containerArtifactClassLoader;
        this.regionPluginClassLoadersFactory = regionPluginClassLoadersFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
    }

    public ToolingArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor applicationDescriptor, File workingDirectory, ToolingArtifactClassLoader parentToolingArtifactClassLoader) {
        try {
            ToolingApplicationClassLoaderBuilder builder = new ToolingApplicationClassLoaderBuilder((DeployableArtifactClassLoaderFactory)new MuleApplicationClassLoaderFactory((NativeLibraryFinderFactory)new ToolingNativeLibraryFinderFactory(workingDirectory)), this.regionPluginClassLoadersFactory);
            HashSet<ArtifactDescriptor> domainPluginDescriptors = new HashSet<ArtifactDescriptor>();
            boolean hasDomainDependency = applicationDescriptor.getDomainDescriptor().isPresent();
            if (!hasDomainDependency) {
                builder.setParentClassLoader(this.containerArtifactClassLoader);
            } else {
                BundleDescriptor declaredDomainDescriptor = (BundleDescriptor)applicationDescriptor.getDomainDescriptor().get();
                if (hasDomainDependency && parentToolingArtifactClassLoader == null) {
                    throw new IllegalStateException(String.format("Application '%s' declares a domain dependency '%s' that should have been already resolved", applicationDescriptor.getArtifactDeclaration().getName(), declaredDomainDescriptor));
                }
                BundleDescriptor parentDomainDescriptor = parentToolingArtifactClassLoader.getArtifactDescriptor().getBundleDescriptor();
                if (!(declaredDomainDescriptor.getGroupId().equals(parentDomainDescriptor.getGroupId()) && declaredDomainDescriptor.getArtifactId().equals(parentDomainDescriptor.getArtifactId()) && declaredDomainDescriptor.getVersion().equals(parentDomainDescriptor.getVersion()))) {
                    throw new IllegalStateException(String.format("Domain class loader to be set for application doesn't match the descriptor, expected: '%s', but was: '%s'", declaredDomainDescriptor, parentDomainDescriptor));
                }
                for (ArtifactClassLoader artifactPluginClassLoader : parentToolingArtifactClassLoader.getArtifactPluginClassLoaders()) {
                    domainPluginDescriptors.add(artifactPluginClassLoader.getArtifactDescriptor());
                }
                builder.setDomainParentClassLoader((ArtifactClassLoader)parentToolingArtifactClassLoader.getRegionClassLoader());
            }
            this.pluginDependenciesResolver.resolve(domainPluginDescriptors, new ArrayList(applicationDescriptor.getPlugins()), true).stream().forEach(xva$0 -> builder.addArtifactPluginDescriptors(new ArtifactPluginDescriptor[]{xva$0}));
            builder.setArtifactDescriptor((ArtifactDescriptor)applicationDescriptor);
            return builder.build();
        }
        catch (Exception e) {
            throw new ToolingException("Error while creating application class loader", (Throwable)e);
        }
    }

    private class ToolingNativeLibraryFinderFactory
    implements NativeLibraryFinderFactory {
        private File workingDirectory;

        public ToolingNativeLibraryFinderFactory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public NativeLibraryFinder create(String name, URL[] urls) {
            return new ArtifactCopyNativeLibraryFinder(new File(new File(this.workingDirectory, name), "temp"), urls);
        }
    }
}

