/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.application.AbstractArtifactDeployer;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.utils.IOUtils;

public class InputStreamArtifactDeployer
extends AbstractArtifactDeployer {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private Function<AbstractArtifactDeployer.DeploymentContext, String> deployFunction;
    private Consumer<AbstractArtifactDeployer.DeploymentContext> disposeFunction;

    public InputStreamArtifactDeployer(ArtifactResources artifactResources, Supplier<RuntimeToolingService> runtimeToolingService, Map<String, String> deploymentProperties) {
        super(artifactResources, runtimeToolingService, deploymentProperties);
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.DOMAIN)) {
            this.deployFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().deployDomain(deploymentContext.getContent(), deploymentContext.getDeploymentProperties());
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeDomain(deploymentContext.getArtifactId());
        } else {
            this.deployFunction = deploymentContext -> {
                if (deploymentContext.getDomainId() != null) {
                    return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getContent(), deploymentContext.getDomainId(), deploymentContext.getDeploymentProperties());
                }
                return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getContent(), deploymentContext.getDeploymentProperties());
            };
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeApplication(deploymentContext.getArtifactId());
        }
    }

    @Override
    protected String doInternalDeploy(ArtifactResources artifactResources, RuntimeToolingService runtimeToolingService, String domainId, Map<String, String> deploymentProperties) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Deploying artifact from URL: {}", (Object)artifactResources);
        }
        byte[] content = IOUtils.readContentFromUrl(artifactResources.getArtifactUrlContent(), 5000, 5000);
        return this.deployFunction.apply((AbstractArtifactDeployer)this.new AbstractArtifactDeployer.DeploymentContext(new ByteArrayInputStream(content), domainId, deploymentProperties, runtimeToolingService));
    }

    @Override
    protected void doInternalDispose(String id, RuntimeToolingService runtimeToolingService) {
        this.disposeFunction.accept(new AbstractArtifactDeployer.DeploymentContext(id, runtimeToolingService));
    }
}

