/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;

import java.io.File;
import java.util.List;
import java.util.Optional;

public interface InternalExtensionModelService {

  /**
   * Loads the {@link ExtensionModel} for the given plugin.
   *
   * @return {@link ExtensionModel} for the plugin or {@link Optional#empty()} if the plugin doesn't have an {@link ExtensionModel}.
   */
  Optional<LoadedExtensionInformation> loadExtensionData(File pluginJarFile);

  /**
   * Loads the {@link ExtensionModel} for Mule Runtime core components.
   *
   * @return {@link ExtensionModel} for Mule Runtime core components.
   */
  List<ExtensionModel> loadRuntimeExtensionModels();

  /**
   * Loads the {@link ArtifactPluginDescriptor} for the given plugin.
   *
   * @param pluginFile {@link File} referencing to the plugin artifact file (packaged or exploded).
   * @return {@link BundleDescriptor} for the plugin.
   */
  BundleDescriptor readBundleDescriptor(File pluginFile);

}
