/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.tooling.client.api.component.ComponentType;
import org.mule.tooling.client.api.component.location.ComponentLocation;
import org.mule.tooling.client.api.component.location.LocationPart;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;

public class ComponentLocationFactory {
    public static ComponentLocation toComponentLocationDTO(org.mule.runtime.api.component.location.ComponentLocation componentLocation) {
        return new ComponentLocation(componentLocation.getLocation(), ComponentLocationFactory.toTypedComponentIdentifierDTO(componentLocation.getComponentIdentifier()), ComponentLocationFactory.toLocationPartsDTO(componentLocation.getParts()), ComponentLocationFactory.toSourceCodeLocationDTO(componentLocation));
    }

    public static List<LocationPart> toLocationPartsDTO(List<org.mule.runtime.api.component.location.LocationPart> locationParts) {
        return locationParts.stream().map(locationPart -> ComponentLocationFactory.toLocationPartDTO(locationPart)).collect(Collectors.toList());
    }

    public static LocationPart toLocationPartDTO(org.mule.runtime.api.component.location.LocationPart locationPart) {
        Optional<SourceCodeLocation> sourceCodeLocation = ComponentLocationFactory.toSourceCodeLocationDTO(locationPart);
        return new LocationPart(locationPart.getPartPath(), ComponentLocationFactory.toTypedComponentIdentifierDTO(locationPart.getPartIdentifier().orElse(null)), sourceCodeLocation);
    }

    public static Optional<SourceCodeLocation> toSourceCodeLocationDTO(org.mule.runtime.api.component.location.LocationPart locationPart) {
        Optional<SourceCodeLocation> sourceCodeLocation = Optional.empty();
        if (locationPart.getFileName().isPresent() && locationPart.getLineInFile().isPresent() && locationPart.getStartColumn().isPresent()) {
            sourceCodeLocation = Optional.of(new SourceCodeLocation((String)locationPart.getFileName().get(), (Integer)locationPart.getLineInFile().get(), (Integer)locationPart.getStartColumn().get()));
        }
        return sourceCodeLocation;
    }

    public static Optional<SourceCodeLocation> toSourceCodeLocationDTO(org.mule.runtime.api.component.location.ComponentLocation componentLocation) {
        Optional<SourceCodeLocation> sourceCodeLocation = Optional.empty();
        if (componentLocation.getFileName().isPresent() && componentLocation.getLineInFile().isPresent() && componentLocation.getStartColumn().isPresent()) {
            sourceCodeLocation = Optional.of(new SourceCodeLocation((String)componentLocation.getFileName().get(), (Integer)componentLocation.getLineInFile().get(), (Integer)componentLocation.getStartColumn().get()));
        }
        return sourceCodeLocation;
    }

    public static org.mule.tooling.client.api.component.TypedComponentIdentifier toTypedComponentIdentifierDTO(TypedComponentIdentifier typedComponentIdentifier) {
        if (typedComponentIdentifier == null) {
            return null;
        }
        ComponentIdentifier componentIdentifier = typedComponentIdentifier.getIdentifier();
        TypedComponentIdentifier.ComponentType componentType = typedComponentIdentifier.getType();
        org.mule.tooling.client.api.component.ComponentIdentifier componentIdentifierDTO = new org.mule.tooling.client.api.component.ComponentIdentifier(componentIdentifier.getName(), componentIdentifier.getNamespace());
        ComponentType componentTypeDTO = ComponentLocationFactory.toComponentTypeToDTO(componentType);
        return new org.mule.tooling.client.api.component.TypedComponentIdentifier(componentIdentifierDTO, componentTypeDTO);
    }

    public static ComponentType toComponentTypeToDTO(TypedComponentIdentifier.ComponentType componentType) {
        if (componentType == TypedComponentIdentifier.ComponentType.FLOW) {
            return ComponentType.flowComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.ERROR_HANDLER) {
            return ComponentType.errorHandlingComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.ON_ERROR) {
            return ComponentType.onErrorComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.OPERATION) {
            return ComponentType.operationComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.ROUTER) {
            return ComponentType.routerComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.SOURCE) {
            return ComponentType.sourceComponentType((String)componentType.name());
        }
        return new ComponentType(componentType.name());
    }
}

