/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.ExtensionModelService;

import java.util.List;

/**
 * {@link ExtensionModelService} that use delegates to {@link InternalExtensionModelService} to resolve {@link ExtensionModel}s
 */
public abstract class AbstractMuleRuntimeExtensionModelProvider implements MuleRuntimeExtensionModelProvider {

  private MavenClient mavenClient;
  protected InternalExtensionModelService extensionModelService;

  /**
   * Creates a new instance
   *
   * @param mavenClient           {@link MavenClient} to resolve artifact.
   * @param extensionModelService the service to use to load {@link ExtensionModel}s in case of a cache miss.
   */
  public AbstractMuleRuntimeExtensionModelProvider(MavenClient mavenClient, InternalExtensionModelService extensionModelService) {
    this.mavenClient = mavenClient;
    this.extensionModelService = extensionModelService;
  }

  @Override
  public List<ExtensionModel> getRuntimeExtensionModels() {
    return extensionModelService.loadRuntimeExtensionModels();
  }

  protected BundleDescriptor toBundleDescriptor(ArtifactDescriptor pluginDescriptor) {
    return new BundleDescriptor.Builder()
        .setGroupId(pluginDescriptor.getGroupId())
        .setArtifactId(pluginDescriptor.getArtifactId())
        .setVersion(pluginDescriptor.getVersion())
        .setBaseVersion(pluginDescriptor.getVersion())
        .setType(pluginDescriptor.getExtension())
        .setClassifier(pluginDescriptor.getClassifier())
        .build();
  }

  protected BundleDependency resolveBundleDependency(BundleDescriptor pluginDescriptor) {
    org.mule.maven.client.api.model.BundleDescriptor.Builder builder =
        new org.mule.maven.client.api.model.BundleDescriptor.Builder();
    builder.setGroupId(pluginDescriptor.getGroupId())
        .setArtifactId(pluginDescriptor.getArtifactId())
        .setType(pluginDescriptor.getType())
        .setVersion(pluginDescriptor.getVersion())
        .setClassifier(pluginDescriptor.getClassifier().orElse(null))
        .build();
    return mavenClient.resolveBundleDescriptor(builder.build());
  }

}
