/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.dsl;

import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CachedDslElementModelFactory implements DslElementModelFactory {

  private DslElementModelFactory delegate;

  private Map<ElementDeclaration, Optional> elementDeclarationCache;
  private Map<ComponentConfiguration, Optional> componentConfigurationCache;

  public CachedDslElementModelFactory(DslElementModelFactory delegate) {
    this.delegate = delegate;
    this.elementDeclarationCache = new HashMap<>();
    this.componentConfigurationCache = new HashMap<>();
  }

  @Override
  public <T> Optional<DslElementModel<T>> create(ElementDeclaration elementDeclaration) {
    return elementDeclarationCache.computeIfAbsent(elementDeclaration, (k) -> delegate.create(k));
  }

  @Override
  public <T> Optional<DslElementModel<T>> create(ComponentConfiguration componentConfiguration) {
    return componentConfigurationCache.computeIfAbsent(componentConfiguration, (k) -> delegate.create(k));
  }
}
