/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import static java.util.Optional.empty;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.tooling.client.internal.dsl.CachedDslElementModelFactory;

import java.util.Optional;

import org.junit.Before;
import org.junit.Test;

public class CachedDslElementModelFactoryTestCase {


  private DslElementModelFactory elementModelFactory;
  private DslElementModelFactory mockedDelegateElementModelFactory;

  @Before
  public void setUp() {
    mockedDelegateElementModelFactory = mock(DslElementModelFactory.class);
    elementModelFactory = new CachedDslElementModelFactory(mockedDelegateElementModelFactory);
  }

  @Test
  public void checkElementModelIsCachedCreatedWithComponentConfiguration() {
    ComponentConfiguration componentConfiguration = mock(ComponentConfiguration.class);

    Optional<DslElementModel<Object>> optionalDslElementModel = Optional.of(mock(DslElementModel.class));
    when(mockedDelegateElementModelFactory.create(eq(componentConfiguration))).thenReturn(optionalDslElementModel);

    assertThat(elementModelFactory.create(componentConfiguration), equalTo(optionalDslElementModel));
    assertThat(elementModelFactory.create(componentConfiguration), equalTo(optionalDslElementModel));

    verify(mockedDelegateElementModelFactory, times(1)).create(any(ComponentConfiguration.class));
  }

  @Test
  public void checkElementModelIsCachedCreatedWithElementDeclaration() {
    ElementDeclaration elementDeclaration = mock(ElementDeclaration.class);

    Optional<DslElementModel<Object>> optionalDslElementModel = Optional.of(mock(DslElementModel.class));
    when(mockedDelegateElementModelFactory.create(eq(elementDeclaration))).thenReturn(optionalDslElementModel);

    assertThat(elementModelFactory.create(elementDeclaration), equalTo(optionalDslElementModel));
    assertThat(elementModelFactory.create(elementDeclaration), equalTo(optionalDslElementModel));

    verify(mockedDelegateElementModelFactory, times(1)).create(any(ElementDeclaration.class));
  }

  @Test
  public void resultIsEmpty() {
    ComponentConfiguration componentConfiguration = mock(ComponentConfiguration.class);
    ElementDeclaration elementDeclaration = mock(ElementDeclaration.class);

    when(mockedDelegateElementModelFactory.create(eq(componentConfiguration))).thenReturn(empty());
    when(mockedDelegateElementModelFactory.create(eq(elementDeclaration))).thenReturn(empty());

    assertThat(elementModelFactory.create(componentConfiguration), equalTo(empty()));
    assertThat(elementModelFactory.create(elementDeclaration), equalTo(empty()));
  }

}
