/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.model.construct.ImmutableConstructModel;
import org.mule.runtime.extension.api.model.function.ImmutableFunctionModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedComponentModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedRouteModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelTargetVersionMediator
implements MuleRuntimeExtensionModelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelTargetVersionMediator.class);
    private static final String EXTENSION_MODELS = "extension-models";
    private static final String EXTENSION_MODEL_MULE = "extension-model-mule-";
    private MuleVersion targetMuleVersion;
    private MuleRuntimeExtensionModelProvider delegate;
    private List<ExtensionModel> runtimeExtensionModels = new ArrayList<ExtensionModel>();

    public ExtensionModelTargetVersionMediator(MuleVersion targetMuleVersion, MuleRuntimeExtensionModelProvider delegate) {
        Preconditions.checkNotNull((Object)targetMuleVersion, (String)"targetMuleVersion cannot be null");
        Preconditions.checkNotNull((Object)delegate, (String)"delegate cannot be null");
        this.targetMuleVersion = targetMuleVersion;
        this.delegate = delegate;
        if (targetMuleVersion.atLeastBase(MuleManifest.getProductVersion())) {
            this.runtimeExtensionModels.addAll(delegate.getRuntimeExtensionModels());
        } else {
            String versionPatchLess = targetMuleVersion.getMajor() + "." + targetMuleVersion.getMinor();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Using {} version of Mule Runtime Extension models", (Object)versionPatchLess);
            }
            ExtensionModelJsonSerializer extensionModelJsonSerializer = new ExtensionModelJsonSerializer();
            this.runtimeExtensionModels.addAll(this.readRuntimeExtensionModels(extensionModelJsonSerializer, versionPatchLess));
        }
    }

    @Override
    public Optional<ExtensionModel> getExtensionModel(ArtifactDescriptor pluginDescriptor) {
        return this.delegate.getExtensionModel(pluginDescriptor).map(extensionModel -> this.filterExtensionModel((ExtensionModel)extensionModel));
    }

    @Override
    public Optional<String> getMinMuleVersion(ArtifactDescriptor pluginDescriptor) {
        return this.delegate.getMinMuleVersion(pluginDescriptor);
    }

    @Override
    public Optional<ExtensionModel> getExtensionModel(File plugin) {
        return this.delegate.getExtensionModel(plugin).map(extensionModel -> this.filterExtensionModel((ExtensionModel)extensionModel));
    }

    @Override
    public Optional<ExtensionModel> getExtensionModel(BundleDependency bundleDependency) {
        return this.delegate.getExtensionModel(bundleDependency).map(extensionModel -> this.filterExtensionModel((ExtensionModel)extensionModel));
    }

    @Override
    public Optional<String> getMinMuleVersion(File plugin) {
        return this.delegate.getMinMuleVersion(plugin);
    }

    @Override
    public Optional<String> getExtensionSchema(File plugin) {
        return this.delegate.getExtensionSchema(plugin);
    }

    @Override
    public Optional<String> getExtensionSchema(ArtifactDescriptor pluginDescriptor) {
        return this.delegate.getExtensionSchema(pluginDescriptor);
    }

    @Override
    public List<ExtensionModel> getRuntimeExtensionModels() {
        return this.runtimeExtensionModels;
    }

    private List<ExtensionModel> readRuntimeExtensionModels(ExtensionModelJsonSerializer extensionModelJsonSerializer, String version) {
        ArrayList<ExtensionModel> runtimeExtensionModels = new ArrayList<ExtensionModel>();
        runtimeExtensionModels.add(this.readRuntimeExtensionModel(extensionModelJsonSerializer, "extension-models/extension-model-mule-" + version + ".json"));
        runtimeExtensionModels.add(this.readRuntimeExtensionModel(extensionModelJsonSerializer, "extension-models/extension-model-mule-ee-" + version + ".json"));
        return runtimeExtensionModels;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtensionModel readRuntimeExtensionModel(ExtensionModelJsonSerializer extensionModelJsonSerializer, String resource) {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(resource);){
            if (resourceAsStream == null) {
                throw new RuntimeException(String.format("Missing extension models resources for runtime version at: %s", resource));
            }
            ExtensionModel extensionModel = extensionModelJsonSerializer.deserialize(IOUtils.toString((InputStream)resourceAsStream));
            return extensionModel;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading extension models for Mule Runtime", e);
        }
    }

    private ExtensionModel filterExtensionModel(ExtensionModel extensionModel) {
        return new ImmutableExtensionModel(extensionModel.getName(), extensionModel.getDescription(), extensionModel.getVersion(), extensionModel.getVendor(), extensionModel.getCategory(), this.filterConfigurationModels(extensionModel.getConfigurationModels()), this.filterOperationModels(extensionModel.getOperationModels()), this.filterConnectionProviders(extensionModel.getConnectionProviders()), this.filterSourceModels(extensionModel.getSourceModels()), this.filterFunctionModels(extensionModel.getFunctionModels()), this.filterConstructModels(extensionModel.getConstructModels()), (DisplayModel)extensionModel.getDisplayModel().orElse(null), extensionModel.getXmlDslModel(), extensionModel.getSubTypes(), extensionModel.getTypes(), extensionModel.getResources(), extensionModel.getImportedTypes(), extensionModel.getErrorModels(), extensionModel.getExternalLibraryModels(), extensionModel.getPrivilegedPackages(), extensionModel.getPrivilegedArtifacts(), extensionModel.getModelProperties(), extensionModel.getNotificationModels(), (DeprecationModel)extensionModel.getDeprecationModel().orElse(null));
    }

    private List<ConfigurationModel> filterConfigurationModels(List<ConfigurationModel> configurationModels) {
        return configurationModels.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(this.targetMuleVersion)).map(configurationModel -> new ImmutableConfigurationModel(configurationModel.getName(), configurationModel.getDescription(), ExtensionModelTargetVersionMediator.filterParameterGroupModels(configurationModel.getParameterGroupModels(), this.targetMuleVersion), this.filterOperationModels(configurationModel.getOperationModels()), this.filterConnectionProviders(configurationModel.getConnectionProviders()), this.filterSourceModels(configurationModel.getSourceModels()), configurationModel.getExternalLibraryModels(), (DisplayModel)configurationModel.getDisplayModel().orElse(null), configurationModel.getStereotype(), configurationModel.getModelProperties(), (DeprecationModel)configurationModel.getDeprecationModel().orElse(null))).collect(Collectors.toList());
    }

    private static List<ParameterGroupModel> filterParameterGroupModels(List<ParameterGroupModel> parameterGroupModels, MuleVersion targetMuleVersion) {
        return parameterGroupModels.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(targetMuleVersion)).map(parameterGroupModel -> new ImmutableParameterGroupModel(parameterGroupModel.getName(), parameterGroupModel.getDescription(), ExtensionModelTargetVersionMediator.filterParameterModels(parameterGroupModel.getParameterModels(), targetMuleVersion), parameterGroupModel.getExclusiveParametersModels(), parameterGroupModel.isShowInDsl(), (DisplayModel)parameterGroupModel.getDisplayModel().orElse(null), (LayoutModel)parameterGroupModel.getLayoutModel().orElse(null), parameterGroupModel.getModelProperties())).collect(Collectors.toList());
    }

    private static List<ParameterModel> filterParameterModels(List<ParameterModel> parameterModels, MuleVersion targetMuleVersion) {
        return parameterModels.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(targetMuleVersion)).map(parameterModel -> new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(), parameterModel.getType(), parameterModel.hasDynamicType(), parameterModel.isRequired(), parameterModel.isOverrideFromConfig(), parameterModel.isComponentId(), parameterModel.getExpressionSupport(), parameterModel.getDefaultValue(), parameterModel.getRole(), parameterModel.getDslConfiguration(), (DisplayModel)parameterModel.getDisplayModel().orElse(null), (LayoutModel)parameterModel.getLayoutModel().orElse(null), (ValueProviderModel)parameterModel.getValueProviderModel().orElse(null), parameterModel.getAllowedStereotypes(), parameterModel.getModelProperties(), (DeprecationModel)parameterModel.getDeprecationModel().orElse(null))).collect(Collectors.toList());
    }

    @NotNull
    private static Predicate<EnrichableModel> filterBySinceModelProperty(MuleVersion targetMuleVersion) {
        return enrichableModel -> enrichableModel.getModelProperty(SinceMuleVersionModelProperty.class).map(sinceMuleVersionModelProperty -> targetMuleVersion.atLeast(sinceMuleVersionModelProperty.getVersion())).orElse(true);
    }

    private List<OperationModel> filterOperationModels(List<OperationModel> operationModels) {
        return operationModels.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(this.targetMuleVersion)).map(operationModel -> ExtensionModelTargetVersionMediator.filterOperationModel(operationModel, this.targetMuleVersion)).collect(Collectors.toList());
    }

    @NotNull
    private static ImmutableOperationModel filterOperationModel(OperationModel operationModel, MuleVersion targetMuleVersion) {
        return new ImmutableOperationModel(operationModel.getName(), operationModel.getDescription(), ExtensionModelTargetVersionMediator.filterParameterGroupModels(operationModel.getParameterGroupModels(), targetMuleVersion), ExtensionModelTargetVersionMediator.filterNestableElementModels(operationModel.getNestedComponents(), targetMuleVersion), operationModel.getOutput(), operationModel.getOutputAttributes(), operationModel.isBlocking(), operationModel.getExecutionType(), operationModel.requiresConnection(), operationModel.isTransactional(), operationModel.supportsStreaming(), (DisplayModel)operationModel.getDisplayModel().orElse(null), operationModel.getErrorModels(), operationModel.getStereotype(), operationModel.getModelProperties(), operationModel.getNotificationModels(), (DeprecationModel)operationModel.getDeprecationModel().orElse(null));
    }

    private static List<? extends NestableElementModel> filterNestableElementModels(List<? extends NestableElementModel> components, MuleVersion targetMuleVersion) {
        return components.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(targetMuleVersion)).map(model -> ExtensionModelTargetVersionMediator.filterNestedComponentModel(model, targetMuleVersion)).collect(Collectors.toList());
    }

    private static NestableElementModel filterNestedComponentModel(NestableElementModel nestedModel, MuleVersion targetMuleVersion) {
        NestableElementModelFilterVisitor nestableElementModelVisitor = new NestableElementModelFilterVisitor(targetMuleVersion);
        nestedModel.accept((NestableElementModelVisitor)nestableElementModelVisitor);
        return nestableElementModelVisitor.getNestableElementModelFiltered();
    }

    private List<ConnectionProviderModel> filterConnectionProviders(List<ConnectionProviderModel> connectionProviders) {
        return connectionProviders.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(this.targetMuleVersion)).map(connectionProviderModel -> new ImmutableConnectionProviderModel(connectionProviderModel.getName(), connectionProviderModel.getDescription(), ExtensionModelTargetVersionMediator.filterParameterGroupModels(connectionProviderModel.getParameterGroupModels(), this.targetMuleVersion), connectionProviderModel.getConnectionManagementType(), connectionProviderModel.supportsConnectivityTesting(), connectionProviderModel.getExternalLibraryModels(), (DisplayModel)connectionProviderModel.getDisplayModel().orElse(null), connectionProviderModel.getStereotype(), connectionProviderModel.getModelProperties(), (DeprecationModel)connectionProviderModel.getDeprecationModel().orElse(null))).collect(Collectors.toList());
    }

    private List<SourceModel> filterSourceModels(List<SourceModel> sourceModels) {
        return sourceModels.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(this.targetMuleVersion)).map(sourceModel -> ExtensionModelTargetVersionMediator.filterSourceModel(sourceModel, this.targetMuleVersion)).collect(Collectors.toList());
    }

    @NotNull
    private static ImmutableSourceModel filterSourceModel(SourceModel sourceModel, MuleVersion targetMuleVersion) {
        return new ImmutableSourceModel(sourceModel.getName(), sourceModel.getDescription(), sourceModel.hasResponse(), sourceModel.runsOnPrimaryNodeOnly(), ExtensionModelTargetVersionMediator.filterParameterGroupModels(sourceModel.getParameterGroupModels(), targetMuleVersion), ExtensionModelTargetVersionMediator.filterNestableElementModels(sourceModel.getNestedComponents(), targetMuleVersion), sourceModel.getOutput(), sourceModel.getOutputAttributes(), sourceModel.getSuccessCallback(), sourceModel.getErrorCallback(), sourceModel.getTerminateCallback(), sourceModel.requiresConnection(), sourceModel.isTransactional(), sourceModel.supportsStreaming(), (DisplayModel)sourceModel.getDisplayModel().orElse(null), sourceModel.getStereotype(), sourceModel.getErrorModels(), sourceModel.getModelProperties(), sourceModel.getNotificationModels(), (DeprecationModel)sourceModel.getDeprecationModel().orElse(null));
    }

    private List<FunctionModel> filterFunctionModels(List<FunctionModel> functionModels) {
        return functionModels.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(this.targetMuleVersion)).map(functionModel -> new ImmutableFunctionModel(functionModel.getName(), functionModel.getDescription(), ExtensionModelTargetVersionMediator.filterParameterGroupModels(functionModel.getParameterGroupModels(), this.targetMuleVersion), functionModel.getOutput(), (DisplayModel)functionModel.getDisplayModel().orElse(null), functionModel.getModelProperties(), (DeprecationModel)functionModel.getDeprecationModel().orElse(null))).collect(Collectors.toList());
    }

    private List<ConstructModel> filterConstructModels(List<ConstructModel> constructModels) {
        return constructModels.stream().filter(ExtensionModelTargetVersionMediator.filterBySinceModelProperty(this.targetMuleVersion)).map(constructModel -> ExtensionModelTargetVersionMediator.filterConstructModel(constructModel, this.targetMuleVersion)).collect(Collectors.toList());
    }

    @NotNull
    private static ImmutableConstructModel filterConstructModel(ConstructModel constructModel, MuleVersion targetMuleVersion) {
        return new ImmutableConstructModel(constructModel.getName(), constructModel.getDescription(), ExtensionModelTargetVersionMediator.filterParameterGroupModels(constructModel.getParameterGroupModels(), targetMuleVersion), ExtensionModelTargetVersionMediator.filterNestableElementModels(constructModel.getNestedComponents(), targetMuleVersion), constructModel.allowsTopLevelDeclaration(), (DisplayModel)constructModel.getDisplayModel().orElse(null), constructModel.getErrorModels(), constructModel.getStereotype(), constructModel.getModelProperties(), (DeprecationModel)constructModel.getDeprecationModel().orElse(null));
    }

    public static class ComponentModelMediator<T extends ComponentModel> {
        private T component;
        private MuleVersion targetMuleVersion;

        public ComponentModelMediator(MuleVersion targetMuleVersion, T component) {
            Preconditions.checkNotNull((Object)targetMuleVersion, (String)"targetMuleVersion cannot be null");
            Preconditions.checkNotNull(component, (String)"component cannot be null");
            this.targetMuleVersion = targetMuleVersion;
            this.component = component;
        }

        public T getFilteredComponentModel() {
            final Reference filteredModel = new Reference();
            this.component.accept(new ComponentModelVisitor(){

                public void visit(ConstructModel constructModel) {
                    filteredModel.set((Object)ExtensionModelTargetVersionMediator.filterConstructModel(constructModel, targetMuleVersion));
                }

                public void visit(OperationModel operationModel) {
                    filteredModel.set((Object)ExtensionModelTargetVersionMediator.filterOperationModel(operationModel, targetMuleVersion));
                }

                public void visit(SourceModel sourceModel) {
                    filteredModel.set((Object)ExtensionModelTargetVersionMediator.filterSourceModel(sourceModel, targetMuleVersion));
                }
            });
            return (T)((ComponentModel)filteredModel.get());
        }
    }

    private static class NestableElementModelFilterVisitor
    implements NestableElementModelVisitor {
        private NestableElementModel nestableElementModel = null;
        private MuleVersion targetMuleVersion;

        public NestableElementModelFilterVisitor(MuleVersion targetMuleVersion) {
            this.targetMuleVersion = targetMuleVersion;
        }

        public NestableElementModel getNestableElementModelFiltered() {
            return this.nestableElementModel;
        }

        public void visit(NestedComponentModel nestedComponentModel) {
            this.nestableElementModel = new ImmutableNestedComponentModel(nestedComponentModel.getName(), nestedComponentModel.getDescription(), (DisplayModel)nestedComponentModel.getDisplayModel().orElse(null), nestedComponentModel.isRequired(), nestedComponentModel.getAllowedStereotypes(), nestedComponentModel.getModelProperties());
        }

        public void visit(NestedChainModel nestedChainModel) {
            this.nestableElementModel = new ImmutableNestedComponentModel(nestedChainModel.getName(), nestedChainModel.getDescription(), (DisplayModel)nestedChainModel.getDisplayModel().orElse(null), nestedChainModel.isRequired(), nestedChainModel.getAllowedStereotypes(), nestedChainModel.getModelProperties());
        }

        public void visit(NestedRouteModel nestedRouteModel) {
            this.nestableElementModel = new ImmutableNestedRouteModel(nestedRouteModel.getName(), nestedRouteModel.getDescription(), ExtensionModelTargetVersionMediator.filterParameterGroupModels(nestedRouteModel.getParameterGroupModels(), this.targetMuleVersion), (DisplayModel)nestedRouteModel.getDisplayModel().orElse(null), nestedRouteModel.getMinOccurs(), (Integer)nestedRouteModel.getMaxOccurs().orElse(null), ExtensionModelTargetVersionMediator.filterNestableElementModels(nestedRouteModel.getNestedComponents(), this.targetMuleVersion), nestedRouteModel.getModelProperties());
        }
    }
}

