/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dsl;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.dsl.DefaultDslSyntaxResolverService;
import org.mule.tooling.client.internal.serialization.Serializer;

class ServiceDelegatingDslSyntaxResolver
implements DslSyntaxResolver,
Command {
    private final DefaultDslSyntaxResolverService delegate;
    private final ExtensionModel toolingModel;
    private final List<ArtifactDescriptor> pluginArtifactDescriptors;
    private final Serializer serializer;

    ServiceDelegatingDslSyntaxResolver(DefaultDslSyntaxResolverService service, ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors, Serializer serializer) {
        this.delegate = service;
        this.toolingModel = toolingModel;
        this.pluginArtifactDescriptors = pluginArtifactDescriptors;
        this.serializer = serializer;
    }

    public DslElementSyntax resolve(ConfigurationModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConnectionProviderModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConstructModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(OperationModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(SourceModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public Optional<DslElementSyntax> resolve(MetadataType type) {
        return this.delegate.resolve(type, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public Set<ObjectType> getSubTypes(ObjectType type) {
        return this.delegate.getSubTypes(type, this.pluginArtifactDescriptors);
    }

    public void dispose() {
        this.delegate.invalidate(this.pluginArtifactDescriptors, this.toolingModel);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "resolve": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                if (classes[0].equals(ConfigurationModel.class.getName())) {
                    return this.serializer.serialize((Object)this.resolve((ConfigurationModel)this.serializer.deserialize(arguments[0])));
                }
                if (classes[0].equals(ConnectionProviderModel.class.getName())) {
                    return this.serializer.serialize((Object)this.resolve((ConnectionProviderModel)this.serializer.deserialize(arguments[0])));
                }
                if (classes[0].equals(ConstructModel.class.getName())) {
                    return this.serializer.serialize((Object)this.resolve((ConstructModel)this.serializer.deserialize(arguments[0])));
                }
                if (classes[0].equals(OperationModel.class.getName())) {
                    return this.serializer.serialize((Object)this.resolve((OperationModel)this.serializer.deserialize(arguments[0])));
                }
                if (classes[0].equals(SourceModel.class.getName())) {
                    return this.serializer.serialize((Object)this.resolve((SourceModel)this.serializer.deserialize(arguments[0])));
                }
                if (classes[0].equals(MetadataType.class.getName())) {
                    return this.serializer.serialize(this.resolve((MetadataType)this.serializer.deserialize(arguments[0])));
                }
                throw Command.notMatchingMethod(this.getClass(), methodName, classes);
            }
            case "getSubTypes": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                if (classes[0].equals(ObjectType.class.getName())) {
                    return this.serializer.serialize(this.getSubTypes((ObjectType)this.serializer.deserialize(arguments[0])));
                }
                throw Command.notMatchingMethod(this.getClass(), methodName, classes);
            }
            case "dispose": {
                this.dispose();
                return null;
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

