/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.api.metadataprovider.CompatibleComponentAst;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.construct.ImmutableConstructModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedComponentModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedRouteModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.tooling.client.internal.metadata.ToolingMetadataCacheIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentModelMediator<T extends ComponentModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentModelMediator.class);
    private CompatibleComponentAst componentAst;
    private ToolingMetadataCacheIdGenerator cacheIdGenerator;
    private Map<String, MetadataType> metadataTypesCache;
    private T component;

    public ComponentModelMediator(Map<String, MetadataType> metadataTypesCache, ToolingMetadataCacheIdGenerator cacheIdGenerator, CompatibleComponentAst componentAst, T component) {
        this.metadataTypesCache = metadataTypesCache;
        this.cacheIdGenerator = cacheIdGenerator;
        this.componentAst = componentAst;
        this.component = component;
    }

    public Optional<T> enrichComponentModel() {
        final Reference filteredModel = new Reference();
        try {
            this.component.accept(new ComponentModelVisitor(){

                public void visit(ConstructModel constructModel) {
                    filteredModel.set((Object)ComponentModelMediator.this.resolveConstructModel(constructModel));
                }

                public void visit(OperationModel operationModel) {
                    filteredModel.set((Object)ComponentModelMediator.this.resolveOperationModel(operationModel));
                }

                public void visit(SourceModel sourceModel) {
                    filteredModel.set((Object)ComponentModelMediator.this.resolveSourceModel(sourceModel));
                }
            });
        }
        catch (MissingDynamicMetadataException e) {
            return Optional.empty();
        }
        return Optional.ofNullable(filteredModel.get());
    }

    private List<ParameterGroupModel> resolveParameterGroupModels(List<ParameterGroupModel> parameterGroupModels) {
        return parameterGroupModels.stream().map(parameterGroupModel -> new ImmutableParameterGroupModel(parameterGroupModel.getName(), parameterGroupModel.getDescription(), this.resolveParameterModels(parameterGroupModel.getParameterModels()), parameterGroupModel.getExclusiveParametersModels(), parameterGroupModel.isShowInDsl(), (DisplayModel)parameterGroupModel.getDisplayModel().orElse(null), (LayoutModel)parameterGroupModel.getLayoutModel().orElse(null), parameterGroupModel.getModelProperties())).collect(Collectors.toList());
    }

    private List<ParameterModel> resolveParameterModels(List<ParameterModel> parameterModels) {
        return parameterModels.stream().map(parameterModel -> {
            MetadataType type = parameterModel.getType();
            if (parameterModel.hasDynamicType()) {
                String componentInputMetadataKey = this.cacheIdGenerator.getIdForComponentInputMetadata(this.componentAst, parameterModel.getName()).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s parameter name: %s", this.componentAst.getLocation(), parameterModel.getName())));
                if (!this.metadataTypesCache.containsKey(componentInputMetadataKey)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Dynamic MetadataType for parameter: %s (component: %s) not present in cache", parameterModel.getName(), this.componentAst.getLocation()));
                    }
                    throw new MissingDynamicMetadataException();
                }
                type = this.metadataTypesCache.get(componentInputMetadataKey);
            }
            return new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(), type, parameterModel.hasDynamicType(), parameterModel.isRequired(), parameterModel.isOverrideFromConfig(), parameterModel.isComponentId(), parameterModel.getExpressionSupport(), parameterModel.getDefaultValue(), parameterModel.getRole(), parameterModel.getDslConfiguration(), (DisplayModel)parameterModel.getDisplayModel().orElse(null), (LayoutModel)parameterModel.getLayoutModel().orElse(null), (ValueProviderModel)parameterModel.getValueProviderModel().orElse(null), parameterModel.getAllowedStereotypes(), parameterModel.getModelProperties(), (DeprecationModel)parameterModel.getDeprecationModel().orElse(null));
        }).collect(Collectors.toList());
    }

    private List<? extends NestableElementModel> resolveNestableElementModels(List<? extends NestableElementModel> components) {
        return components.stream().map(this::resolveNestedComponentModel).collect(Collectors.toList());
    }

    private NestableElementModel resolveNestedComponentModel(NestableElementModel nestedModel) {
        NestableElementModelFilterVisitor nestableElementModelVisitor = new NestableElementModelFilterVisitor();
        nestedModel.accept((NestableElementModelVisitor)nestableElementModelVisitor);
        return nestableElementModelVisitor.getNestableElementModelFiltered();
    }

    private ImmutableOperationModel resolveOperationModel(OperationModel operationModel) {
        return new ImmutableOperationModel(operationModel.getName(), operationModel.getDescription(), this.resolveParameterGroupModels(operationModel.getParameterGroupModels()), this.resolveNestableElementModels(operationModel.getNestedComponents()), this.resolveOutputModel(operationModel.getOutput()), this.resolveOutputAttributesModel(operationModel.getOutputAttributes()), operationModel.isBlocking(), operationModel.getExecutionType(), operationModel.requiresConnection(), operationModel.isTransactional(), operationModel.supportsStreaming(), (DisplayModel)operationModel.getDisplayModel().orElse(null), operationModel.getErrorModels(), operationModel.getStereotype(), operationModel.getModelProperties(), operationModel.getNotificationModels(), (DeprecationModel)operationModel.getDeprecationModel().orElse(null));
    }

    private OutputModel resolveOutputModel(OutputModel outputModel) {
        MetadataType type = outputModel.getType();
        if (outputModel.hasDynamicType()) {
            String componentOutputMetadataKey = this.cacheIdGenerator.getIdForComponentOutputMetadata(this.componentAst).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s output", this.componentAst.getLocation())));
            if (!this.metadataTypesCache.containsKey(componentOutputMetadataKey)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Dynamic output MetadataType for component: %s not present in cache", this.componentAst.getLocation()));
                }
                throw new MissingDynamicMetadataException();
            }
            type = this.metadataTypesCache.get(componentOutputMetadataKey);
        }
        return new ImmutableOutputModel(outputModel.getDescription(), type, outputModel.hasDynamicType(), outputModel.getModelProperties());
    }

    private OutputModel resolveOutputAttributesModel(OutputModel outputModel) {
        MetadataType type = outputModel.getType();
        if (outputModel.hasDynamicType()) {
            String componentAttributesMetadataKey = this.cacheIdGenerator.getIdForComponentAttributesMetadata(this.componentAst).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s output attributes", this.componentAst.getLocation())));
            if (!this.metadataTypesCache.containsKey(componentAttributesMetadataKey)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Dynamic output attributes MetadataType for component: %s not present in cache", this.componentAst.getLocation()));
                }
                throw new MissingDynamicMetadataException();
            }
            type = this.metadataTypesCache.get(componentAttributesMetadataKey);
        }
        return new ImmutableOutputModel(outputModel.getDescription(), type, outputModel.hasDynamicType(), outputModel.getModelProperties());
    }

    private ImmutableSourceModel resolveSourceModel(SourceModel sourceModel) {
        return new ImmutableSourceModel(sourceModel.getName(), sourceModel.getDescription(), sourceModel.hasResponse(), sourceModel.runsOnPrimaryNodeOnly(), this.resolveParameterGroupModels(sourceModel.getParameterGroupModels()), this.resolveNestableElementModels(sourceModel.getNestedComponents()), this.resolveOutputModel(sourceModel.getOutput()), this.resolveOutputAttributesModel(sourceModel.getOutputAttributes()), sourceModel.getSuccessCallback(), sourceModel.getErrorCallback(), sourceModel.getTerminateCallback(), sourceModel.requiresConnection(), sourceModel.isTransactional(), sourceModel.supportsStreaming(), (DisplayModel)sourceModel.getDisplayModel().orElse(null), sourceModel.getStereotype(), sourceModel.getErrorModels(), sourceModel.getModelProperties(), sourceModel.getNotificationModels(), (DeprecationModel)sourceModel.getDeprecationModel().orElse(null));
    }

    private ImmutableConstructModel resolveConstructModel(ConstructModel constructModel) {
        return new ImmutableConstructModel(constructModel.getName(), constructModel.getDescription(), this.resolveParameterGroupModels(constructModel.getParameterGroupModels()), this.resolveNestableElementModels(constructModel.getNestedComponents()), constructModel.allowsTopLevelDeclaration(), (DisplayModel)constructModel.getDisplayModel().orElse(null), constructModel.getErrorModels(), constructModel.getStereotype(), constructModel.getModelProperties(), (DeprecationModel)constructModel.getDeprecationModel().orElse(null));
    }

    public static class MissingDynamicMetadataException
    extends RuntimeException {
    }

    private class NestableElementModelFilterVisitor
    implements NestableElementModelVisitor {
        private NestableElementModel nestableElementModel = null;

        private NestableElementModelFilterVisitor() {
        }

        public NestableElementModel getNestableElementModelFiltered() {
            return this.nestableElementModel;
        }

        public void visit(NestedComponentModel nestedComponentModel) {
            this.nestableElementModel = new ImmutableNestedComponentModel(nestedComponentModel.getName(), nestedComponentModel.getDescription(), (DisplayModel)nestedComponentModel.getDisplayModel().orElse(null), nestedComponentModel.isRequired(), nestedComponentModel.getAllowedStereotypes(), nestedComponentModel.getModelProperties());
        }

        public void visit(NestedChainModel nestedChainModel) {
            this.nestableElementModel = new ImmutableNestedComponentModel(nestedChainModel.getName(), nestedChainModel.getDescription(), (DisplayModel)nestedChainModel.getDisplayModel().orElse(null), nestedChainModel.isRequired(), nestedChainModel.getAllowedStereotypes(), nestedChainModel.getModelProperties());
        }

        public void visit(NestedRouteModel nestedRouteModel) {
            this.nestableElementModel = new ImmutableNestedRouteModel(nestedRouteModel.getName(), nestedRouteModel.getDescription(), ComponentModelMediator.this.resolveParameterGroupModels(nestedRouteModel.getParameterGroupModels()), (DisplayModel)nestedRouteModel.getDisplayModel().orElse(null), nestedRouteModel.getMinOccurs(), (Integer)nestedRouteModel.getMaxOccurs().orElse(null), ComponentModelMediator.this.resolveNestableElementModels(nestedRouteModel.getNestedComponents()), nestedRouteModel.getModelProperties());
        }
    }
}

