/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import static org.mule.tooling.client.internal.serialization.KryoFactory.defaultKryo;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;

public class DefaultMetadataCacheStorageSerializer implements MetadataCacheStorageSerializer {

  private Kryo kryoSerializer;

  public DefaultMetadataCacheStorageSerializer() {
    this.kryoSerializer = defaultKryo();
  }

  @Override
  public void serialize(OutputStream outputStream, Object object) {
    try (Output output = new Output(new BufferedOutputStream(Base64.getEncoder().wrap(outputStream)))) {
      kryoSerializer.writeClassAndObject(output, object);
    }
  }

  @Override
  public <T> T deserialize(InputStream serialized) {
    try (Input input = new Input(new BufferedInputStream(Base64.getDecoder().wrap(serialized)))) {
      return (T) kryoSerializer.readClassAndObject(input);
    }
  }
}
