/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.sameInstance;
import static org.junit.Assert.assertThat;
import static org.junit.rules.ExpectedException.none;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.mule.tooling.agent.rest.client.ConnectionValidationResultFactory.success;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Feature("RequestTimeout")
@Story("ConnectityTestingRequestTimeout")
public class ConnectivityTestingRequestTimeoutTestCase {

  @Rule
  public ExpectedException expectedException = none();

  @Test
  @Description("Checks that exceptions from service are propagated even when timeout wrapper is used")
  public void unsupportedConnectivityTesting() {
    ToolingArtifact target = mock(ToolingArtifact.class);
    final ConnectivityTestingRequest request = new ConnectivityTestingRequest();
    ConnectivityTestingService connectivityTestingService = mock(ConnectivityTestingService.class);
    when(target.connectivityTestingService()).thenReturn(connectivityTestingService);
    when(connectivityTestingService.testConnection(request))
        .thenThrow(new UnsupportedConnectivityTestingObjectException("error", new RuntimeException("cause")));

    expectedException.expect(UnsupportedConnectivityTestingObjectException.class);
    target.connectivityTestingService().testConnection(request);
  }

  @Test
  @Description("Checks the successful scenario for connectivity testing using timeout wrapper")
  public void successful() {
    ToolingArtifact target = mock(ToolingArtifact.class);
    final ConnectivityTestingRequest request = new ConnectivityTestingRequest();
    final ConnectionValidationResult response = success();
    ConnectivityTestingService connectivityTestingService = mock(ConnectivityTestingService.class);
    when(target.connectivityTestingService()).thenReturn(connectivityTestingService);
    when(connectivityTestingService.testConnection(request)).thenReturn(response);

    ConnectionValidationResult result = target.connectivityTestingService().testConnection(request);
    assertThat(result.isValid(), is(true));
    assertThat(result, sameInstance(response));
  }

}
